/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.schema;

import java.sql.Connection;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class SchemaDropHelper {
    public static void drop(Metadata metadata) {
        SchemaDropHelper.drop(metadata, (ServiceRegistry)((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry());
    }

    public static void drop(Metadata metadata, ServiceRegistry serviceRegistry) {
        Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        settings.put("javax.persistence.schema-generation.database.action", Action.DROP);
        SchemaManagementToolCoordinator.process((Metadata)metadata, (ServiceRegistry)serviceRegistry, (Map)settings, (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
    }

    public static void drop(MetadataImplementor metadata, StandardServiceRegistry serviceRegistry, Connection connection) {
        Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        settings.put("javax.persistence.schema-generation.database.action", Action.DROP);
        settings.put("javax.persistence.schema-generation-connection", connection);
        SchemaManagementToolCoordinator.process((Metadata)metadata, (ServiceRegistry)serviceRegistry, (Map)settings, (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
    }
}

