/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.ServiceRegistryExtension;
import org.hibernate.testing.orm.junit.ServiceRegistryScope;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class ServiceRegistryParameterResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return JUnitHelper.supportsParameterInjection(parameterContext, StandardServiceRegistry.class, ServiceRegistryScope.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ServiceRegistryScope scope = ServiceRegistryExtension.findServiceRegistryScope(extensionContext.getRequiredTestInstance(), extensionContext);
        Class<ServiceRegistryScope> paramType = parameterContext.getParameter().getType();
        if (paramType.isAssignableFrom(ServiceRegistryScope.class)) {
            return scope;
        }
        if (paramType.isAssignableFrom(StandardServiceRegistry.class)) {
            return scope.getRegistry();
        }
        throw new IllegalStateException("Unexpected parameter type [" + paramType.getName() + "] for service-registry injection");
    }
}

