/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Optional;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.ServiceContributor;
import org.hibernate.testing.boot.ExtraJavaServicesClassLoaderService;
import org.hibernate.testing.jdbc.SQLStatementInspector;
import org.hibernate.testing.orm.junit.BootstrapServiceRegistry;
import org.hibernate.testing.orm.junit.BootstrapServiceRegistryProducer;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.ServiceRegistry;
import org.hibernate.testing.orm.junit.ServiceRegistryProducer;
import org.hibernate.testing.orm.junit.ServiceRegistryScope;
import org.hibernate.testing.orm.junit.ServiceRegistryScopeAware;
import org.hibernate.testing.orm.junit.Setting;
import org.hibernate.testing.orm.junit.SettingProvider;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class ServiceRegistryExtension
implements TestInstancePostProcessor,
AfterAllCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(ServiceRegistryExtension.class);
    private static final String REGISTRY_KEY = ServiceRegistryScope.class.getName();

    public static StandardServiceRegistry findServiceRegistry(Object testInstance, ExtensionContext context) {
        return ServiceRegistryExtension.findServiceRegistryScope(testInstance, context).getRegistry();
    }

    private static ExtensionContext.Store locateExtensionStore(Object testInstance, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(ServiceRegistryExtension.class, context, testInstance);
    }

    public static ServiceRegistryScope findServiceRegistryScope(Object testInstance, ExtensionContext context) {
        log.tracef("#findServiceRegistryScope(%s, %s)", testInstance, (Object)context.getDisplayName());
        ExtensionContext.Store store = ServiceRegistryExtension.locateExtensionStore(testInstance, context);
        ServiceRegistryScopeImpl existingScope = (ServiceRegistryScopeImpl)store.get((Object)REGISTRY_KEY);
        if (existingScope == null) {
            log.debugf("Creating ServiceRegistryScope - %s", (Object)context.getDisplayName());
            Optional bsrAnnWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), BootstrapServiceRegistry.class);
            BootstrapServiceRegistryProducer bsrProducer = bsrAnnWrapper.isPresent() ? bsrBuilder -> {
                BootstrapServiceRegistry bsrAnn = (BootstrapServiceRegistry)bsrAnnWrapper.get();
                ServiceRegistryExtension.configureJavaServices(bsrAnn, bsrBuilder);
                ServiceRegistryExtension.configureIntegrators(bsrAnn, bsrBuilder);
                return bsrBuilder.enableAutoClose().build();
            } : BootstrapServiceRegistryBuilder::build;
            ServiceRegistryProducer ssrProducer = testInstance instanceof ServiceRegistryProducer ? (ServiceRegistryProducer)testInstance : new ServiceRegistryProducerImpl(context);
            ServiceRegistryScopeImpl scope = new ServiceRegistryScopeImpl(bsrProducer, ssrProducer);
            scope.getRegistry();
            ServiceRegistryExtension.locateExtensionStore(testInstance, context).put((Object)REGISTRY_KEY, (Object)scope);
            if (testInstance instanceof ServiceRegistryScopeAware) {
                ((ServiceRegistryScopeAware)testInstance).injectServiceRegistryScope(scope);
            }
            return scope;
        }
        return existingScope;
    }

    private static void configureIntegrators(BootstrapServiceRegistry bsrAnn, BootstrapServiceRegistryBuilder bsrBuilder) {
        Class<? extends Integrator>[] integrators = bsrAnn.integrators();
        if (integrators.length == 0) {
            return;
        }
        for (Class<? extends Integrator> integratorImpl : integrators) {
            assert (integratorImpl != null);
            try {
                Constructor<? extends Integrator> constructor = integratorImpl.getDeclaredConstructor(new Class[0]);
                Integrator integrator = constructor.newInstance(new Object[0]);
                bsrBuilder.applyIntegrator(integrator);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find no-arg constructor for Integrator : " + integratorImpl.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access no-arg constructor for Integrator : " + integratorImpl.getName(), e);
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException("Unable to instantiate Integrator : " + integratorImpl.getName(), e);
            }
        }
    }

    private static void configureJavaServices(BootstrapServiceRegistry bsrAnn, BootstrapServiceRegistryBuilder bsrBuilder) {
        BootstrapServiceRegistry.JavaService[] javaServiceAnns = bsrAnn.javaServices();
        if (javaServiceAnns.length == 0) {
            return;
        }
        ArrayList javaServiceDescriptors = new ArrayList(javaServiceAnns.length);
        for (int i = 0; i < javaServiceAnns.length; ++i) {
            BootstrapServiceRegistry.JavaService javaServiceAnn = javaServiceAnns[i];
            javaServiceDescriptors.add(new ExtraJavaServicesClassLoaderService.JavaServiceDescriptor(javaServiceAnn.role(), javaServiceAnn.impl()));
        }
        ExtraJavaServicesClassLoaderService cls = new ExtraJavaServicesClassLoaderService(javaServiceDescriptors);
        bsrBuilder.applyClassLoaderService((ClassLoaderService)cls);
    }

    private static void configureServices(ServiceRegistry serviceRegistryAnn, StandardServiceRegistryBuilder ssrb) {
        try {
            for (Setting setting : serviceRegistryAnn.settings()) {
                ssrb.applySetting(setting.name(), (Object)setting.value());
            }
            for (Annotation annotation : serviceRegistryAnn.settingProviders()) {
                Class<SettingProvider.Provider<?>> providerImpl = annotation.provider();
                SettingProvider.Provider<?> provider = providerImpl.getConstructor(new Class[0]).newInstance(new Object[0]);
                ssrb.applySetting(annotation.settingName(), provider.getSetting());
            }
            for (Class<? extends ServiceContributor> clazz : serviceRegistryAnn.serviceContributors()) {
                ServiceContributor serviceContributor = (ServiceContributor)clazz.newInstance();
                serviceContributor.contribute(ssrb);
            }
            for (Class<? extends StandardServiceInitiator> clazz : serviceRegistryAnn.initiators()) {
                ssrb.addInitiator((StandardServiceInitiator)clazz.newInstance());
            }
            for (ServiceRegistry.Service service : serviceRegistryAnn.services()) {
                ssrb.addService(service.role(), service.impl().newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure StandardServiceRegistryBuilder", e);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.tracef("#postProcessTestInstance(%s, %s)", testInstance, (Object)context.getDisplayName());
        ServiceRegistryExtension.findServiceRegistryScope(testInstance, context);
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store;
        ServiceRegistryScopeImpl scope;
        log.tracef("#afterAll(%s)", (Object)context.getDisplayName());
        Object testInstance = context.getRequiredTestInstance();
        if (testInstance instanceof ServiceRegistryScopeAware) {
            ((ServiceRegistryScopeAware)testInstance).injectServiceRegistryScope(null);
        }
        if ((scope = (ServiceRegistryScopeImpl)(store = ServiceRegistryExtension.locateExtensionStore(testInstance, context)).remove((Object)REGISTRY_KEY)) != null) {
            scope.close();
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.tracef("#handleTestExecutionException(%s, %s)", (Object)context.getDisplayName(), (Object)throwable);
        Object testInstance = context.getRequiredTestInstance();
        ExtensionContext.Store store = ServiceRegistryExtension.locateExtensionStore(testInstance, context);
        ServiceRegistryScopeImpl scope = (ServiceRegistryScopeImpl)store.get((Object)REGISTRY_KEY);
        scope.releaseRegistry();
        throw throwable;
    }

    private static class ServiceRegistryScopeImpl
    implements ServiceRegistryScope,
    ExtensionContext.Store.CloseableResource {
        private BootstrapServiceRegistryProducer bsrProducer;
        private ServiceRegistryProducer ssrProducer;
        private StandardServiceRegistry registry;
        private boolean active = true;

        public ServiceRegistryScopeImpl(BootstrapServiceRegistryProducer bsrProducer, ServiceRegistryProducer ssrProducer) {
            this.bsrProducer = bsrProducer;
            this.ssrProducer = ssrProducer;
        }

        private StandardServiceRegistry createRegistry() {
            BootstrapServiceRegistryBuilder bsrb = new BootstrapServiceRegistryBuilder().enableAutoClose();
            this.ssrProducer.prepareBootstrapRegistryBuilder(bsrb);
            org.hibernate.boot.registry.BootstrapServiceRegistry bsr = this.bsrProducer.produceServiceRegistry(bsrb);
            try {
                StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder(bsr);
                ssrb.disableAutoClose();
                this.registry = this.ssrProducer.produceServiceRegistry(ssrb);
                return this.registry;
            }
            catch (Throwable t) {
                bsr.close();
                throw t;
            }
        }

        private void verifyActive() {
            if (!this.active) {
                throw new IllegalStateException("ServiceRegistryScope no longer active");
            }
        }

        @Override
        public StandardServiceRegistry getRegistry() {
            this.verifyActive();
            if (this.registry == null) {
                this.registry = this.createRegistry();
            }
            return this.registry;
        }

        public void close() {
            if (!this.active) {
                return;
            }
            log.debugf("Closing ServiceRegistryScope", new Object[0]);
            this.active = false;
            if (this.registry != null) {
                this.releaseRegistry();
                this.registry = null;
            }
        }

        private void releaseRegistry() {
            if (this.registry == null) {
                return;
            }
            try {
                log.tracef("#releaseRegistry", new Object[0]);
                StandardServiceRegistryBuilder.destroy((org.hibernate.service.ServiceRegistry)this.registry);
            }
            catch (Exception e) {
                log.warn((Object)"Unable to release StandardServiceRegistry", (Throwable)e);
            }
            finally {
                this.registry = null;
            }
        }
    }

    private static class ServiceRegistryProducerImpl
    implements ServiceRegistryProducer {
        private final ExtensionContext context;

        public ServiceRegistryProducerImpl(ExtensionContext context) {
            this.context = context;
            if (!context.getElement().isPresent()) {
                throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
            }
        }

        @Override
        public StandardServiceRegistry produceServiceRegistry(StandardServiceRegistryBuilder ssrb) {
            ssrb.applySetting("hibernate.session_factory.statement_inspector", SQLStatementInspector.class);
            Optional ssrAnnWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)this.context.getElement().get()), ServiceRegistry.class);
            if (ssrAnnWrapper.isPresent()) {
                ServiceRegistry serviceRegistryAnn = (ServiceRegistry)ssrAnnWrapper.get();
                ServiceRegistryExtension.configureServices(serviceRegistryAnn, ssrb);
            }
            return ssrb.build();
        }

        @Override
        public void prepareBootstrapRegistryBuilder(BootstrapServiceRegistryBuilder bsrb) {
        }
    }
}

