/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.animal;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.hibernate.testing.orm.domain.animal.Human;
import org.hibernate.testing.orm.domain.animal.Zoo;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class Animal {
    private Long id;
    private float bodyWeight;
    private Set offspring;
    private Animal mother;
    private Animal father;
    private String description;
    private Zoo zoo;
    private String serialNumber;

    public Animal() {
    }

    public Animal(String description, float bodyWeight) {
        this.description = description;
        this.bodyWeight = bodyWeight;
    }

    @Id
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="body_weight")
    public float getBodyWeight() {
        return this.bodyWeight;
    }

    public void setBodyWeight(float bodyWeight) {
        this.bodyWeight = bodyWeight;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @ManyToOne
    @JoinColumn(name="zoo_fk")
    public Zoo getZoo() {
        return this.zoo;
    }

    public void setZoo(Zoo zoo) {
        this.zoo = zoo;
    }

    @ManyToOne
    @JoinColumn(name="mother_fk")
    public Animal getMother() {
        return this.mother;
    }

    public void setMother(Animal mother) {
        this.mother = mother;
    }

    @ManyToOne
    @JoinColumn(name="father_fk")
    public Animal getFather() {
        return this.father;
    }

    public void setFather(Animal father) {
        this.father = father;
    }

    @OneToMany
    @JoinColumn(name="mother_fk")
    @OrderBy(value="father_fk")
    public Set<Human> getOffspring() {
        return this.offspring;
    }

    public void addOffspring(Animal offspring) {
        if (this.offspring == null) {
            this.offspring = new HashSet();
        }
        this.offspring.add(offspring);
    }

    public void setOffspring(Set offspring) {
        this.offspring = offspring;
    }
}

