/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotationBuilder {
    String annotation;
    LinkedHashMap attributes = new LinkedHashMap();

    public static AnnotationBuilder createAnnotation(String annotation) {
        return new AnnotationBuilder(annotation);
    }

    protected AnnotationBuilder(String annotation) {
        this.annotation = annotation;
    }

    public AnnotationBuilder addAttribute(String name, String[] values) {
        if (values != null && values.length > 0) {
            this.attributes.put(name, values);
        }
        return this;
    }

    public AnnotationBuilder addAttribute(String name, String value) {
        if (value != null) {
            this.addAttribute(name, new String[]{value});
        }
        return this;
    }

    public AnnotationBuilder resetAnnotation(String annotationName) {
        this.annotation = annotationName;
        this.clearAttributes();
        return this;
    }

    private AnnotationBuilder clearAttributes() {
        this.attributes.clear();
        return this;
    }

    public String getResult() {
        StringBuffer b = new StringBuffer("@");
        b.append(this.annotation);
        if (this.attributes.isEmpty()) {
            return b.toString();
        }
        b.append("(");
        Iterator elements = this.attributes.entrySet().iterator();
        boolean addedBefore = false;
        while (elements.hasNext()) {
            Map.Entry element = elements.next();
            String[] s = (String[])element.getValue();
            if (s.length == 0) {
                addedBefore = false;
                continue;
            }
            if (addedBefore) {
                b.append(", ");
            }
            String key = (String)element.getKey();
            b.append(key).append("=");
            this.attributeToString(b, s);
            addedBefore = true;
        }
        b.append(")");
        return b.toString();
    }

    private void attributeToString(StringBuffer buffer, String[] values) {
        if (values.length > 1) {
            buffer.append("{");
        }
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]);
            if (i >= values.length - 1) continue;
            buffer.append(", ");
        }
        if (values.length > 1) {
            buffer.append("}");
        }
    }

    public void addQuotedAttributes(String name, Iterator iterator) {
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            String element = iterator.next().toString();
            values.add(this.quote(element));
        }
        this.addAttribute(name, values.toArray(new String[values.size()]));
    }

    public void addAttributes(String name, Iterator iterator) {
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            String element = iterator.next().toString();
            values.add(element);
        }
        this.addAttribute(name, values.toArray(new String[values.size()]));
    }

    private String quote(String element) {
        return "\"" + element + "\"";
    }

    public AnnotationBuilder addQuotedAttribute(String name, String value) {
        if (value != null) {
            this.addAttribute(name, this.quote(value));
        }
        return this;
    }

    public String toString() {
        return this.getResult();
    }

    public String getAttributeAsString(String name) {
        StringBuffer buffer = new StringBuffer();
        String[] object = (String[])this.attributes.get(name);
        if (object == null) {
            return null;
        }
        this.attributeToString(buffer, object);
        return buffer.toString();
    }
}

