/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Properties;
import org.hibernate.cfg.MetaDataDialectFactory;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.service.ServiceRegistry;

public final class JDBCReaderFactory {
    public static JDBCReader newJDBCReader(Properties properties, ReverseEngineeringStrategy revengStrategy, ServiceRegistry serviceRegistry) {
        MetaDataDialect mdd = MetaDataDialectFactory.createMetaDataDialect(((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect(), properties);
        return JDBCReaderFactory.newJDBCReader(properties, revengStrategy, mdd, serviceRegistry);
    }

    public static JDBCReader newJDBCReader(Properties properties, ReverseEngineeringStrategy revengStrategy, MetaDataDialect mdd, ServiceRegistry serviceRegistry) {
        SQLExceptionConverter sqlExceptionConverter = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getSqlExceptionHelper().getSqlExceptionConverter();
        ConnectionProvider connectionProvider = (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
        String defaultCatalogName = properties.getProperty("hibernate.default_catalog");
        String defaultSchemaName = properties.getProperty("hibernate.default_schema");
        return new JDBCReader(mdd, connectionProvider, sqlExceptionConverter, defaultCatalogName, defaultSchemaName, revengStrategy);
    }
}

