/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.tool.hbm2x.TemplateProducer;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class HibernateMappingExporter
extends GenericExporter {
    protected HibernateMappingGlobalSettings globalSettings = new HibernateMappingGlobalSettings();

    @Override
    protected void setupContext() {
        super.setupContext();
        this.getTemplateHelper().putInContext("hmgs", this.globalSettings);
    }

    public void setGlobalSettings(HibernateMappingGlobalSettings hgs) {
        this.globalSettings = hgs;
    }

    @Override
    public void doStart() {
        this.exportGeneralSettings();
        super.doStart();
    }

    private void exportGeneralSettings() {
        Metadata md;
        Cfg2HbmTool c2h = this.getCfg2HbmTool();
        if (c2h.isImportData(md = this.getMetadata()) && c2h.isNamedQueries(md) && c2h.isNamedSQLQueries(md) && c2h.isFilterDefinitions(md)) {
            TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
            producer.produce(new HashMap<String, Object>(), "hbm/generalhbm.hbm.ftl", new File(this.getOutputDirectory(), "GeneralHbmSettings.hbm.xml"), this.getTemplateName(), "General Settings");
        }
    }

    public HibernateMappingExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
        this.init();
    }

    protected void init() {
        this.setTemplateName("hbm/hibernate-mapping.hbm.ftl");
        this.setFilePattern("{package-name}/{class-name}.hbm.xml");
    }

    public HibernateMappingExporter() {
        this.init();
    }

    @Override
    protected String getClassNameForFile(POJOClass element) {
        return StringHelper.unqualify((String)((PersistentClass)element.getDecoratedObject()).getEntityName());
    }

    @Override
    protected String getPackageNameForFile(POJOClass element) {
        return StringHelper.qualifier((String)((PersistentClass)element.getDecoratedObject()).getClassName());
    }

    @Override
    protected void exportComponent(Map<String, Object> additionalContext, POJOClass element) {
    }

    @Override
    public String getName() {
        return "hbm2hbmxml";
    }
}

