/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.EnumSet;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.util.MetadataHelper;

public class Hbm2DDLExporter
extends AbstractExporter {
    protected boolean exportToDatabase = true;
    protected boolean scriptToConsole = true;
    protected boolean schemaUpdate = false;
    protected String delimiter = ";";
    protected boolean drop = false;
    protected boolean create = true;
    protected boolean format = false;
    protected String outputFileName = null;
    protected boolean haltOnError = false;

    public Hbm2DDLExporter() {
    }

    public Hbm2DDLExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    protected boolean setupBoolProperty(String property, boolean defaultVal) {
        if (!this.getProperties().containsKey(property)) {
            return defaultVal;
        }
        return Boolean.parseBoolean(this.getProperties().getProperty(property));
    }

    @Override
    protected void setupContext() {
        this.exportToDatabase = this.setupBoolProperty("exportToDatabase", this.exportToDatabase);
        this.scriptToConsole = this.setupBoolProperty("scriptToConsole", this.scriptToConsole);
        this.schemaUpdate = this.setupBoolProperty("schemaUpdate", this.schemaUpdate);
        this.delimiter = this.getProperties().getProperty("delimiter", this.delimiter);
        this.drop = this.setupBoolProperty("drop", this.drop);
        this.create = this.setupBoolProperty("create", this.create);
        this.format = this.setupBoolProperty("format", this.format);
        this.outputFileName = this.getProperties().getProperty("outputFileName", this.outputFileName);
        this.haltOnError = this.setupBoolProperty("haltOnError", this.haltOnError);
        super.setupContext();
    }

    @Override
    protected void cleanUpContext() {
        super.cleanUpContext();
    }

    @Override
    protected void doStart() {
        Configuration configuration = this.getConfiguration();
        Metadata metadata = MetadataHelper.getMetadata(configuration);
        EnumSet<TargetType> targetTypes = EnumSet.noneOf(TargetType.class);
        if (this.scriptToConsole) {
            targetTypes.add(TargetType.STDOUT);
        }
        if (this.exportToDatabase) {
            targetTypes.add(TargetType.DATABASE);
        }
        if (null != this.outputFileName) {
            targetTypes.add(TargetType.SCRIPT);
        }
        if (this.schemaUpdate) {
            SchemaUpdate update = new SchemaUpdate();
            if (this.outputFileName == null && this.delimiter == null && this.haltOnError && this.format) {
                update.execute(targetTypes, metadata);
            } else {
                if (null != this.outputFileName) {
                    File outputFile = new File(this.getOutputDirectory(), this.outputFileName);
                    update.setOutputFile(outputFile.getPath());
                    this.log.debug("delimiter ='" + this.delimiter + "'");
                    update.setDelimiter(this.delimiter);
                    update.setFormat(Boolean.valueOf(this.format).booleanValue());
                }
                if (this.haltOnError) {
                    update.setHaltOnError(Boolean.valueOf(this.haltOnError).booleanValue());
                }
                update.execute(targetTypes, metadata);
                if (!update.getExceptions().isEmpty()) {
                    int i = 1;
                    for (Throwable element : update.getExceptions()) {
                        this.log.warn("Error #" + i + ": ", element);
                        ++i;
                    }
                    this.log.error(i - 1 + " errors occurred while performing Hbm2DDLExporter.");
                    if (this.haltOnError) {
                        throw new ExporterException("Errors while performing Hbm2DDLExporter");
                    }
                }
            }
        } else {
            SchemaExport export = new SchemaExport();
            if (null != this.outputFileName) {
                export.setOutputFile(new File(this.getOutputDirectory(), this.outputFileName).toString());
            }
            if (null != this.delimiter) {
                export.setDelimiter(this.delimiter);
            }
            export.setHaltOnError(this.haltOnError);
            export.setFormat(this.format);
            if (this.drop && this.create) {
                export.execute(targetTypes, SchemaExport.Action.BOTH, metadata);
            } else if (this.drop) {
                export.execute(targetTypes, SchemaExport.Action.DROP, metadata);
            } else if (this.create) {
                export.execute(targetTypes, SchemaExport.Action.CREATE, metadata);
            } else {
                export.execute(targetTypes, SchemaExport.Action.NONE, metadata);
            }
        }
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }
}

