/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbmlint.HbmLint;
import org.hibernate.tool.util.MetadataHelper;

public class HbmLintExporter
extends GenericExporter {
    private static final String TEXT_REPORT_FTL = "lint/text-report.ftl";

    public HbmLintExporter() {
    }

    public HbmLintExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    @Override
    public void start() {
        this.setFilePattern("hbmlint-result.txt");
        this.setTemplateName(TEXT_REPORT_FTL);
        super.start();
    }

    @Override
    protected void setupContext() {
        HbmLint hbmlint = HbmLint.createInstance();
        hbmlint.analyze(MetadataHelper.getMetadata(this.getConfiguration()));
        this.getProperties().put("lintissues", hbmlint.getResults());
        super.setupContext();
    }

    @Override
    public String getName() {
        return "hbmlint";
    }
}

