/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;

public class ConfigurationTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private MetadataDescriptor metadataDescriptor;
    private File configurationFile;
    private File propertyFile;
    protected String entityResolver;

    public ConfigurationTask() {
        this.setDescription("Standard Configuration");
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public final MetadataDescriptor getMetadataDescriptor() {
        if (this.metadataDescriptor == null) {
            this.metadataDescriptor = this.createMetadataDescriptor();
        }
        return this.metadataDescriptor;
    }

    protected MetadataDescriptor createMetadataDescriptor() {
        return MetadataDescriptorFactory.createNativeDescriptor(this.configurationFile, this.getFiles(), this.loadPropertiesFile());
    }

    protected Properties loadPropertiesFile() {
        if (this.propertyFile != null) {
            Properties properties = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.propertyFile);
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
            catch (FileNotFoundException e) {
                throw new BuildException(this.propertyFile + " not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("Problem while loading " + this.propertyFile, (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    protected File[] getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (FileSet fs : this.fileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            for (int j = 0; j < dsFiles.length; ++j) {
                File f = new File(dsFiles[j]);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(f);
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setEntityResolver(String entityResolverName) {
        this.entityResolver = entityResolverName;
    }

    public void setNamingStrategy(String namingStrategy) {
    }
}

