/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.DuplicateMappingException;
import org.hibernate.FetchMode;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.JDBCCollectionSecondPass;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.binder.BinderUtils;
import org.hibernate.cfg.binder.PrimaryKeyInfo;
import org.hibernate.cfg.binder.PropertyBinder;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.MappingsDatabaseCollector;
import org.hibernate.cfg.reveng.RevEngUtils;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.utils.JdbcToHibernateTypeHelper;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.util.TableNameQualifier;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.jboss.logging.Logger;

public class JDBCBinder {
    private Properties properties;
    private static final Logger log = Logger.getLogger(JDBCBinder.class);
    private final MetadataBuildingContext mdbc;
    private final InFlightMetadataCollector metadataCollector;
    private Metadata metadata;
    private ReverseEngineeringStrategy revengStrategy;
    private final boolean preferBasicCompositeIds;
    private final ServiceRegistry serviceRegistry;
    private final String defaultCatalog;
    private final String defaultSchema;

    public JDBCBinder(ServiceRegistry serviceRegistry, Properties properties, MetadataBuildingContext mdbc, ReverseEngineeringStrategy revengStrategy, boolean preferBasicCompositeIds) {
        this.serviceRegistry = serviceRegistry;
        this.mdbc = mdbc;
        this.properties = properties;
        this.revengStrategy = revengStrategy;
        this.preferBasicCompositeIds = preferBasicCompositeIds;
        this.defaultCatalog = properties.getProperty("hibernate.default_catalog");
        this.defaultSchema = properties.getProperty("hibernate.default_schema");
        this.metadataCollector = mdbc.getMetadataCollector();
        this.metadata = ((InFlightMetadataCollectorImpl)this.metadataCollector).buildMetadataInstance(mdbc);
    }

    public void readFromDatabase(String catalog, String schema, Mapping mapping) {
        try {
            DatabaseCollector collector = this.readDatabaseSchema(catalog, schema);
            this.createPersistentClasses(collector, mapping);
            ((InFlightMetadataCollectorImpl)this.metadataCollector).processSecondPasses(this.mdbc);
        }
        catch (SQLException e) {
            JdbcServices jdbcServices = (JdbcServices)this.serviceRegistry.getService(JdbcServices.class);
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Reading from database", null);
        }
    }

    public DatabaseCollector readDatabaseSchema(String catalog, String schema) throws SQLException {
        catalog = catalog != null ? catalog : this.properties.getProperty("hibernate.default_catalog");
        schema = schema != null ? schema : this.properties.getProperty("hibernate.default_schema");
        JDBCReader reader = JDBCReaderFactory.newJDBCReader(this.properties, this.revengStrategy, this.serviceRegistry);
        MappingsDatabaseCollector dbs = new MappingsDatabaseCollector(this.metadataCollector, reader.getMetaDataDialect());
        reader.readDatabaseSchema(dbs, catalog, schema);
        return dbs;
    }

    private void createPersistentClasses(DatabaseCollector collector, Mapping mapping) {
        Map<String, List<ForeignKey>> manyToOneCandidates = collector.getOneToManyCandidates();
        for (Table table : this.metadataCollector.collectTableMappings()) {
            if (table.getCatalog() != null && table.getCatalog().equals(this.defaultCatalog)) {
                table.setCatalog(null);
            }
            if (table.getSchema() != null && table.getSchema().equals(this.defaultSchema)) {
                table.setSchema(null);
            }
            if (table.getColumnSpan() == 0) {
                log.warn((Object)("Cannot create persistent class for " + table + " as no columns were found."));
                continue;
            }
            if (this.revengStrategy.isManyToManyTable(table)) {
                log.debug((Object)("Ignoring " + table + " as class since rev.eng. says it is a many-to-many"));
                continue;
            }
            RootClass rc = new RootClass(this.mdbc);
            TableIdentifier tableIdentifier = TableIdentifier.create(table);
            String className = this.revengStrategy.tableToClassName(tableIdentifier);
            log.debug((Object)("Building entity " + className + " based on " + tableIdentifier));
            rc.setEntityName(className);
            rc.setJpaEntityName(StringHelper.unqualify((String)className));
            rc.setClassName(className);
            rc.setProxyInterfaceName(rc.getEntityName());
            rc.setLazy(true);
            rc.setMetaAttributes(BinderUtils.safeMap(RevEngUtils.getTableToMetaAttributesInRevengStrategy(this.revengStrategy, table, this.defaultCatalog, this.defaultSchema)));
            rc.setDiscriminatorValue(rc.getEntityName());
            rc.setTable(table);
            rc.setOptimisticLockStyle(OptimisticLockStyle.NONE);
            try {
                this.metadataCollector.addEntityBinding((PersistentClass)rc);
            }
            catch (DuplicateMappingException dme) {
                PersistentClass class1 = this.metadataCollector.getEntityBinding(dme.getName());
                Table table2 = class1.getTable();
                throw new JDBCBinderException("Duplicate class name '" + rc.getEntityName() + "' generated for '" + table + "'. Same name where generated for '" + table2 + "'");
            }
            this.metadataCollector.addImport(rc.getEntityName(), rc.getEntityName());
            HashSet<Column> processed = new HashSet<Column>();
            PrimaryKeyInfo pki = this.bindPrimaryKeyToProperties(table, rc, processed, mapping, collector);
            this.bindColumnsToVersioning(table, rc, processed, mapping);
            this.bindOutgoingForeignKeys(table, rc, processed);
            this.bindColumnsToProperties(table, rc, processed, mapping);
            List<ForeignKey> incomingForeignKeys = manyToOneCandidates.get(rc.getEntityName());
            this.bindIncomingForeignKeys((PersistentClass)rc, processed, incomingForeignKeys, mapping);
            this.updatePrimaryKey(rc, pki);
        }
    }

    private void updatePrimaryKey(RootClass rc, PrimaryKeyInfo pki) {
        SimpleValue idValue = (SimpleValue)rc.getIdentifierProperty().getValue();
        Properties defaultStrategyProperties = new Properties();
        Property constrainedOneToOne = this.getConstrainedOneToOne(rc);
        if (constrainedOneToOne != null) {
            if (pki.suggestedStrategy == null) {
                idValue.setIdentifierGeneratorStrategy("foreign");
            }
            if (pki.suggestedProperties == null) {
                defaultStrategyProperties.setProperty("property", constrainedOneToOne.getName());
                idValue.setIdentifierGeneratorProperties(defaultStrategyProperties);
            }
        }
    }

    private Property getConstrainedOneToOne(RootClass rc) {
        Iterator propertyClosureIterator = rc.getPropertyClosureIterator();
        while (propertyClosureIterator.hasNext()) {
            OneToOne oto;
            Property property = (Property)propertyClosureIterator.next();
            if (!(property.getValue() instanceof OneToOne) || !(oto = (OneToOne)property.getValue()).isConstrained()) continue;
            return property;
        }
        return null;
    }

    private void bindIncomingForeignKeys(PersistentClass rc, java.util.Set<Column> processed, List<ForeignKey> foreignKeys, Mapping mapping) {
        if (foreignKeys != null) {
            for (ForeignKey foreignKey : foreignKeys) {
                Property property;
                if (this.revengStrategy.excludeForeignKeyAsCollection(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns())) {
                    log.debug((Object)("Rev.eng excluded one-to-many or one-to-one for foreignkey " + foreignKey.getName()));
                    continue;
                }
                if (this.revengStrategy.isOneToOne(foreignKey)) {
                    property = this.bindOneToOne(rc, foreignKey.getTable(), foreignKey, processed, false, true);
                    rc.addProperty(property);
                    continue;
                }
                property = this.bindOneToMany(rc, foreignKey, processed, mapping);
                rc.addProperty(property);
            }
        }
    }

    private Property bindOneToOne(PersistentClass rc, Table targetTable, ForeignKey fk, java.util.Set<Column> processedColumns, boolean constrained, boolean inverseProperty) {
        OneToOne value = new OneToOne(this.mdbc, targetTable, rc);
        value.setReferencedEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(targetTable)));
        boolean isUnique = this.isUniqueReference(fk);
        String propertyName = null;
        propertyName = inverseProperty ? this.revengStrategy.foreignKeyToInverseEntityName(fk.getName(), TableIdentifier.create(fk.getReferencedTable()), fk.getReferencedColumns(), TableIdentifier.create(targetTable), fk.getColumns(), isUnique) : this.revengStrategy.foreignKeyToEntityName(fk.getName(), TableIdentifier.create(fk.getReferencedTable()), fk.getReferencedColumns(), TableIdentifier.create(targetTable), fk.getColumns(), isUnique);
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        value.setFetchMode(FetchMode.SELECT);
        value.setConstrained(constrained);
        value.setForeignKeyType(constrained ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT);
        return this.makeEntityProperty(propertyName, true, targetTable, fk, (ToOne)value, inverseProperty);
    }

    private Property bindManyToOne(String propertyName, boolean mutable, Table table, ForeignKey fk, java.util.Set<Column> processedColumns) {
        ManyToOne value = new ManyToOne(this.mdbc, table);
        value.setReferencedEntityName(fk.getReferencedEntityName());
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        value.setFetchMode(FetchMode.SELECT);
        return this.makeEntityProperty(propertyName, mutable, table, fk, (ToOne)value, false);
    }

    private Property makeCollectionProperty(String propertyName, boolean mutable, Table table, ForeignKey fk, Collection value, boolean inverseProperty) {
        AssociationInfo fkei = inverseProperty ? this.revengStrategy.foreignKeyToInverseAssociationInfo(fk) : this.revengStrategy.foreignKeyToAssociationInfo(fk);
        String fetchMode = null;
        String cascade = null;
        boolean update = mutable;
        boolean insert = mutable;
        if (fkei != null) {
            cascade = fkei.getCascade();
            if (cascade == null) {
                cascade = "all";
            }
            if (fkei.getUpdate() != null) {
                update = fkei.getUpdate();
            }
            if (fkei.getInsert() != null) {
                insert = fkei.getInsert();
            }
            fetchMode = fkei.getFetch();
        }
        if (FetchMode.JOIN.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.JOIN);
        } else if (FetchMode.SELECT.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.SELECT);
        } else {
            value.setFetchMode(FetchMode.SELECT);
        }
        return PropertyBinder.makeProperty(table, this.defaultCatalog, this.defaultSchema, propertyName, (Value)value, insert, update, value.getFetchMode() != FetchMode.JOIN, cascade, null, this.revengStrategy);
    }

    private Property makeEntityProperty(String propertyName, boolean mutable, Table table, ForeignKey fk, ToOne value, boolean inverseProperty) {
        AssociationInfo fkei = inverseProperty ? this.revengStrategy.foreignKeyToInverseAssociationInfo(fk) : this.revengStrategy.foreignKeyToAssociationInfo(fk);
        String fetchMode = null;
        String cascade = null;
        boolean update = mutable;
        boolean insert = mutable;
        if (fkei != null) {
            cascade = fkei.getCascade();
            if (fkei.getUpdate() != null) {
                update = fkei.getUpdate();
            }
            if (fkei.getInsert() != null) {
                insert = fkei.getInsert();
            }
            fetchMode = fkei.getFetch();
        }
        if (FetchMode.JOIN.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.JOIN);
        } else if (FetchMode.SELECT.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.SELECT);
        } else {
            value.setFetchMode(FetchMode.SELECT);
        }
        return PropertyBinder.makeProperty(table, this.defaultCatalog, this.defaultSchema, propertyName, (Value)value, insert, update, value.getFetchMode() != FetchMode.JOIN, cascade, null, this.revengStrategy);
    }

    private Property bindOneToMany(PersistentClass rc, ForeignKey foreignKey, java.util.Set<Column> processed, Mapping mapping) {
        Table collectionTable = foreignKey.getTable();
        Set collection = new Set(this.mdbc, rc);
        collection.setCollectionTable(collectionTable);
        boolean manyToMany = this.revengStrategy.isManyToManyTable(collectionTable);
        if (manyToMany) {
            // empty if block
        }
        if (manyToMany) {
            ManyToOne element = new ManyToOne(this.mdbc, collection.getCollectionTable());
            Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
            ArrayList<ForeignKey> keys = new ArrayList<ForeignKey>();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey next = (ForeignKey)foreignKeyIterator.next();
                if (next == foreignKey) continue;
                keys.add(next);
            }
            if (keys.size() > 1) {
                throw new JDBCBinderException("more than one other foreign key to choose from!");
            }
            ForeignKey fk = (ForeignKey)keys.get(0);
            String tableToClassName = this.bindCollection(rc, foreignKey, fk, (Collection)collection);
            element.setReferencedEntityName(tableToClassName);
            for (Column fkcolumn : fk.getColumns()) {
                if (fkcolumn.getSqlTypeCode() != null) {
                    this.guessAndAlignType(fk.getTable(), fkcolumn, mapping, false);
                }
                element.addColumn(fkcolumn);
            }
            collection.setElement((Value)element);
        } else {
            String tableToClassName = this.bindCollection(rc, foreignKey, null, (Collection)collection);
            OneToMany oneToMany = new OneToMany(this.mdbc, collection.getOwner());
            oneToMany.setReferencedEntityName(tableToClassName);
            this.metadataCollector.addSecondPass((SecondPass)new JDBCCollectionSecondPass(this.mdbc, (Collection)collection));
            collection.setElement((Value)oneToMany);
        }
        String propRef = collection.getReferencedPropertyName();
        KeyValue referencedKeyValue = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propRef).getValue();
        DependantValue keyValue = new DependantValue(this.mdbc, collectionTable, referencedKeyValue);
        Iterator columnIterator = foreignKey.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column fkcolumn = (Column)columnIterator.next();
            if (fkcolumn.getSqlTypeCode() != null) {
                this.guessAndAlignType(collectionTable, fkcolumn, mapping, false);
            }
            keyValue.addColumn(fkcolumn);
        }
        collection.setKey((KeyValue)keyValue);
        this.metadataCollector.addCollectionBinding((Collection)collection);
        return this.makeCollectionProperty(StringHelper.unqualify((String)collection.getRole()), true, rc.getTable(), foreignKey, (Collection)collection, true);
    }

    private String bindCollection(PersistentClass rc, ForeignKey fromForeignKey, ForeignKey toForeignKey, Collection collection) {
        String tableToClassName;
        ForeignKey targetKey = fromForeignKey;
        String collectionRole = null;
        boolean collectionLazy = false;
        boolean collectionInverse = false;
        TableIdentifier foreignKeyTable = null;
        if (toForeignKey != null) {
            targetKey = toForeignKey;
        }
        boolean uniqueReference = this.isUniqueReference(targetKey);
        foreignKeyTable = TableIdentifier.create(targetKey.getTable());
        TableIdentifier foreignKeyReferencedTable = TableIdentifier.create(targetKey.getReferencedTable());
        if (toForeignKey == null) {
            collectionRole = this.revengStrategy.foreignKeyToCollectionName(fromForeignKey.getName(), foreignKeyTable, fromForeignKey.getColumns(), foreignKeyReferencedTable, fromForeignKey.getReferencedColumns(), uniqueReference);
            tableToClassName = this.revengStrategy.tableToClassName(foreignKeyTable);
        } else {
            collectionRole = this.revengStrategy.foreignKeyToManyToManyName(fromForeignKey, TableIdentifier.create(fromForeignKey.getTable()), toForeignKey, uniqueReference);
            tableToClassName = this.revengStrategy.tableToClassName(foreignKeyReferencedTable);
        }
        collectionInverse = this.revengStrategy.isForeignKeyCollectionInverse(targetKey.getName(), foreignKeyTable, targetKey.getColumns(), foreignKeyReferencedTable, targetKey.getReferencedColumns());
        collectionLazy = this.revengStrategy.isForeignKeyCollectionLazy(targetKey.getName(), foreignKeyTable, targetKey.getColumns(), foreignKeyReferencedTable, targetKey.getReferencedColumns());
        collectionRole = BinderUtils.makeUnique(rc, collectionRole);
        String fullRolePath = StringHelper.qualify((String)rc.getEntityName(), (String)collectionRole);
        if (this.metadata.getCollectionBinding(fullRolePath) != null) {
            log.debug((Object)(fullRolePath + " found twice!"));
        }
        collection.setRole(fullRolePath);
        collection.setInverse(collectionInverse);
        collection.setLazy(collectionLazy);
        collection.setFetchMode(FetchMode.SELECT);
        return tableToClassName;
    }

    private boolean isUniqueReference(ForeignKey foreignKey) {
        Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
        while (foreignKeyIterator.hasNext()) {
            ForeignKey element = (ForeignKey)foreignKeyIterator.next();
            if (element == foreignKey || !element.getReferencedTable().equals(foreignKey.getReferencedTable())) continue;
            return false;
        }
        return true;
    }

    private PrimaryKeyInfo bindPrimaryKeyToProperties(Table table, RootClass rc, java.util.Set<Column> processed, Mapping mapping, DatabaseCollector collector) {
        boolean naturalId;
        SimpleValue id = null;
        String idPropertyname = null;
        PrimaryKeyInfo pki = new PrimaryKeyInfo();
        ArrayList<Column> keyColumns = null;
        if (table.getPrimaryKey() != null) {
            keyColumns = table.getPrimaryKey().getColumns();
        } else {
            log.debug((Object)("No primary key found for " + table + ", using all properties as the identifier."));
            keyColumns = new ArrayList<Column>();
            Iterator iter = table.getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyColumns.add(col);
            }
        }
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        String tableIdentifierStrategyName = "assigned";
        if (keyColumns.size() > 1) {
            log.debug((Object)("id strategy for " + rc.getEntityName() + " since it has a multiple column primary key"));
            naturalId = true;
            id = this.handleCompositeKey(rc, processed, keyColumns, mapping);
            idPropertyname = this.revengStrategy.tableToIdentifierPropertyName(tableIdentifier);
            if (idPropertyname == null) {
                idPropertyname = "id";
            }
        } else {
            pki.suggestedStrategy = RevEngUtils.getTableIdentifierStrategyNameInRevengStrategy(this.revengStrategy, table, this.defaultCatalog, this.defaultSchema);
            String suggestedStrategy = pki.suggestedStrategy;
            if (suggestedStrategy == null) {
                suggestedStrategy = collector.getSuggestedIdentifierStrategy(tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getName());
                if (suggestedStrategy == null) {
                    suggestedStrategy = "assigned";
                }
                tableIdentifierStrategyName = suggestedStrategy;
            } else {
                tableIdentifierStrategyName = suggestedStrategy;
            }
            naturalId = "assigned".equals(tableIdentifierStrategyName);
            Column pkc = (Column)keyColumns.get(0);
            this.checkColumn(pkc);
            id = this.bindColumnToSimpleValue(table, pkc, mapping, !naturalId);
            idPropertyname = this.revengStrategy.tableToIdentifierPropertyName(tableIdentifier);
            if (idPropertyname == null) {
                idPropertyname = this.revengStrategy.columnToPropertyName(tableIdentifier, pkc.getName());
            }
            processed.add(pkc);
        }
        id.setIdentifierGeneratorStrategy(tableIdentifierStrategyName);
        pki.suggestedProperties = this.revengStrategy.getTableIdentifierProperties(tableIdentifier);
        id.setIdentifierGeneratorProperties(pki.suggestedProperties);
        if (naturalId) {
            id.setNullValue("undefined");
        }
        Property property = PropertyBinder.makeProperty(table, this.defaultCatalog, this.defaultSchema, BinderUtils.makeUnique((PersistentClass)rc, idPropertyname), (Value)id, true, true, false, null, null, this.revengStrategy);
        rc.setIdentifierProperty(property);
        rc.setIdentifier((KeyValue)id);
        return pki;
    }

    private void bindOutgoingForeignKeys(Table table, RootClass rc, java.util.Set<Column> processedColumns) {
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            boolean mutable = true;
            if (this.contains(foreignKey.getColumnIterator(), processedColumns)) {
                if (!this.preferBasicCompositeIds) continue;
                mutable = false;
            }
            if (this.revengStrategy.excludeForeignKeyAsManytoOne(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns())) {
                log.debug((Object)("Rev.eng excluded *-to-one for foreignkey " + foreignKey.getName()));
                continue;
            }
            if (this.revengStrategy.isOneToOne(foreignKey)) {
                Property property = this.bindOneToOne((PersistentClass)rc, foreignKey.getReferencedTable(), foreignKey, processedColumns, true, false);
                rc.addProperty(property);
                continue;
            }
            boolean isUnique = this.isUniqueReference(foreignKey);
            String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), isUnique);
            Property property = this.bindManyToOne(BinderUtils.makeUnique((PersistentClass)rc, propertyName), mutable, table, foreignKey, processedColumns);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToProperties(Table table, RootClass rc, java.util.Set<Column> processedColumns, Mapping mapping) {
        Iterator iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (processedColumns.contains(column)) continue;
            this.checkColumn(column);
            String propertyName = RevEngUtils.getColumnToPropertyNameInRevengStrategy(this.revengStrategy, table, this.defaultCatalog, this.defaultSchema, column.getName());
            Property property = this.bindBasicProperty(BinderUtils.makeUnique((PersistentClass)rc, propertyName), table, column, processedColumns, mapping);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToVersioning(Table table, RootClass rc, java.util.Set<Column> processed, Mapping mapping) {
        TableIdentifier identifier = TableIdentifier.create(table);
        String optimisticLockColumnName = this.revengStrategy.getOptimisticLockColumnName(identifier);
        if (optimisticLockColumnName != null) {
            Column column = table.getColumn(new Column(optimisticLockColumnName));
            if (column == null) {
                log.warn((Object)("Column " + column + " wanted for <version>/<timestamp> not found in " + identifier));
            } else {
                this.bindVersionProperty(table, identifier, column, rc, processed, mapping);
            }
        } else {
            log.debug((Object)("Scanning " + identifier + " for <version>/<timestamp> columns."));
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                boolean useIt = this.revengStrategy.useColumnForOptimisticLock(identifier, column.getName());
                if (!useIt || processed.contains(column)) continue;
                this.bindVersionProperty(table, identifier, column, rc, processed, mapping);
                return;
            }
            log.debug((Object)("No columns reported while scanning for <version>/<timestamp> columns in " + identifier));
        }
    }

    private void bindVersionProperty(Table table, TableIdentifier identifier, Column column, RootClass rc, java.util.Set<Column> processed, Mapping mapping) {
        processed.add(column);
        String propertyName = this.revengStrategy.columnToPropertyName(identifier, column.getName());
        Property property = this.bindBasicProperty(BinderUtils.makeUnique((PersistentClass)rc, propertyName), table, column, processed, mapping);
        rc.addProperty(property);
        rc.setVersion(property);
        rc.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
        log.debug((Object)("Column " + column.getName() + " will be used for <version>/<timestamp> columns in " + identifier));
    }

    private Property bindBasicProperty(String propertyName, Table table, Column column, java.util.Set<Column> processedColumns, Mapping mapping) {
        SimpleValue value = this.bindColumnToSimpleValue(table, column, mapping, false);
        return PropertyBinder.makeProperty(table, this.defaultCatalog, this.defaultSchema, propertyName, (Value)value, true, true, false, null, null, this.revengStrategy);
    }

    private SimpleValue bindColumnToSimpleValue(Table table, Column column, Mapping mapping, boolean generatedIdentifier) {
        SimpleValue value = new SimpleValue(this.mdbc, table);
        value.addColumn(column);
        value.setTypeName(this.guessAndAlignType(table, column, mapping, generatedIdentifier));
        return value;
    }

    private boolean contains(Iterator<Column> columnIterator, java.util.Set<Column> processedColumns) {
        while (columnIterator.hasNext()) {
            Column element = columnIterator.next();
            if (!processedColumns.contains(element)) continue;
            return true;
        }
        return false;
    }

    private void checkColumn(Column column) {
        if (column.getValue() != null) {
            // empty if block
        }
    }

    private String guessAndAlignType(Table table, Column column, Mapping mapping, boolean generatedIdentifier) {
        Integer sqlTypeCode = column.getSqlTypeCode();
        String location = "Table: " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getQuotedName()) + " column: " + column.getQuotedName();
        if (sqlTypeCode == null) {
            throw new JDBCBinderException("sqltype is null for " + location);
        }
        String preferredHibernateType = this.revengStrategy.columnToHibernateTypeName(TableIdentifier.create(table), column.getName(), sqlTypeCode, column.getLength(), column.getPrecision(), column.getScale(), column.isNullable(), generatedIdentifier);
        BasicType wantedType = this.metadataCollector.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(preferredHibernateType);
        if (wantedType != null) {
            int[] wantedSqlTypes = wantedType.sqlTypes(mapping);
            if (wantedSqlTypes.length > 1) {
                throw new JDBCBinderException("The type " + preferredHibernateType + " found on " + location + " spans multiple columns. Only single column types allowed.");
            }
            int wantedSqlType = wantedSqlTypes[0];
            if (wantedSqlType != sqlTypeCode) {
                log.debug((Object)("Sql type mismatch for " + location + " between DB and wanted hibernate type. Sql type set to " + this.typeCodeName(sqlTypeCode) + " instead of " + this.typeCodeName(wantedSqlType)));
                column.setSqlTypeCode(new Integer(wantedSqlType));
            }
        } else {
            log.debug((Object)("No Hibernate type found for " + preferredHibernateType + ". Most likely cause is a missing UserType class."));
        }
        if (preferredHibernateType == null) {
            throw new JDBCBinderException("Could not find javatype for " + this.typeCodeName(sqlTypeCode));
        }
        return preferredHibernateType;
    }

    private String typeCodeName(int sqlTypeCode) {
        return sqlTypeCode + "(" + JdbcToHibernateTypeHelper.getJDBCTypeName(sqlTypeCode) + ")";
    }

    private SimpleValue handleCompositeKey(RootClass rc, java.util.Set<Column> processedColumns, List<Column> keyColumns, Mapping mapping) {
        Component pkc = new Component(this.mdbc, (PersistentClass)rc);
        pkc.setMetaAttributes(Collections.EMPTY_MAP);
        pkc.setEmbedded(false);
        String compositeIdName = this.revengStrategy.tableToCompositeIdName(TableIdentifier.create(rc.getTable()));
        if (compositeIdName == null) {
            compositeIdName = this.revengStrategy.classNameToCompositeIdName(rc.getClassName());
        }
        pkc.setComponentClassName(compositeIdName);
        Table table = rc.getTable();
        List<Object> list = null;
        list = this.preferBasicCompositeIds ? new ArrayList<Column>(keyColumns) : this.findForeignKeys(table.getForeignKeyIterator(), keyColumns);
        for (Object element : list) {
            Property property;
            if (element instanceof Column) {
                Column column = (Column)element;
                if (processedColumns.contains(column)) {
                    throw new JDBCBinderException("Binding column twice for primary key should not happen: " + column);
                }
                this.checkColumn(column);
                String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
                property = this.bindBasicProperty(BinderUtils.makeUnique(pkc, propertyName), table, column, processedColumns, mapping);
                processedColumns.add(column);
            } else if (element instanceof ForeignKeyForColumns) {
                ForeignKeyForColumns fkfc = (ForeignKeyForColumns)element;
                ForeignKey foreignKey = fkfc.key;
                String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), true);
                property = this.bindManyToOne(BinderUtils.makeUnique(pkc, propertyName), true, table, foreignKey, processedColumns);
                processedColumns.addAll(fkfc.columns);
            } else {
                throw new JDBCBinderException("unknown thing");
            }
            this.markAsUseInEquals(property);
            pkc.addProperty(property);
        }
        return pkc;
    }

    private void markAsUseInEquals(Property property) {
        HashMap<String, MetaAttribute> m = new HashMap<String, MetaAttribute>();
        MetaAttribute ma = new MetaAttribute("use-in-equals");
        ma.addValue("true");
        m.put(ma.getName(), ma);
        property.setMetaAttributes(m);
    }

    private List<Object> findForeignKeys(Iterator<?> foreignKeyIterator, List<Column> pkColumns) {
        ArrayList<ForeignKey> tempList = new ArrayList<ForeignKey>();
        while (foreignKeyIterator.hasNext()) {
            tempList.add((ForeignKey)foreignKeyIterator.next());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Column[] myPkColumns = pkColumns.toArray(new Column[pkColumns.size()]);
        for (int i = 0; i < myPkColumns.length; ++i) {
            boolean foundKey = false;
            foreignKeyIterator = tempList.iterator();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey key = (ForeignKey)foreignKeyIterator.next();
                List<Column> matchingColumns = this.columnMatches(myPkColumns, i, key);
                if (matchingColumns == null) continue;
                result.add(new ForeignKeyForColumns(key, matchingColumns));
                i += matchingColumns.size() - 1;
                foreignKeyIterator.remove();
                foundKey = true;
                break;
            }
            if (foundKey) continue;
            result.add(myPkColumns[i]);
        }
        return result;
    }

    private List<Column> columnMatches(Column[] myPkColumns, int offset, ForeignKey key) {
        if (key.getColumnSpan() > myPkColumns.length - offset) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int j = 0; j < key.getColumnSpan(); ++j) {
            Column column = myPkColumns[j + offset];
            if (!column.equals(key.getColumn(j))) {
                return null;
            }
            columns.add(column);
        }
        return columns.isEmpty() ? null : columns;
    }

    static class ForeignKeyForColumns {
        protected final List<Column> columns;
        protected final ForeignKey key;

        public ForeignKeyForColumns(ForeignKey key, List<Column> columns) {
            this.key = key;
            this.columns = columns;
        }
    }
}

