/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.hibernate.HibernateException;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;

public class JPAConfigurationTask
extends ConfigurationTask {
    private String persistenceUnit = null;

    public JPAConfigurationTask() {
        this.setDescription("JPA Configuration");
    }

    @Override
    protected MetadataDescriptor createMetadataDescriptor() {
        try {
            Properties overrides = new Properties();
            Properties p = this.loadPropertiesFile();
            if (p != null) {
                overrides.putAll((Map<?, ?>)p);
            }
            return MetadataDescriptorFactory.createJpaDescriptor(this.persistenceUnit, overrides);
        }
        catch (HibernateException t) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw new BuildException(cause);
            }
            throw new BuildException("Problems in creating a configuration for JPA. Have you remembered to add hibernate EntityManager jars to the classpath ?", (Throwable)t);
        }
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    @Override
    public void setConfigurationFile(File configurationFile) {
        this.complain("configurationfile");
    }

    private void complain(String param) {
        throw new BuildException("<" + this.getTaskName() + "> currently only support autodiscovery from META-INF/persistence.xml. Thus setting the " + param + " attribute is not allowed");
    }
}

