/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.xml;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.tool.hbm2x.xml.AbstractXMLPrettyPrinterStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class TrAXPrettyPrinterStrategy
extends AbstractXMLPrettyPrinterStrategy {
    private int indent = 4;
    private boolean omitXmlDeclaration;

    @Override
    public String prettyPrint(String xml) throws Exception {
        Document document = this.newDocument(xml, "UTF-8");
        this.removeWhitespace(document);
        Transformer transformer = this.newTransformer(document);
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    protected Transformer newTransformer(Document document) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = this.newTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", this.isOmitXmlDeclaration() ? "yes" : "no");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.getIndent()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DocumentType doctype = document.getDoctype();
        if (doctype != null) {
            transformer.setOutputProperty("doctype-public", doctype.getPublicId());
            transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        }
        return transformer;
    }

    protected TransformerFactory newTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", this.getIndent());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return transformerFactory;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }
}

