/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.RelationalModelDetector;
import org.hibernate.tool.hbmlint.detector.TableSelectorStrategy;
import org.hibernate.tool.util.TableNameQualifier;

public class SchemaByMetaDataDetector
extends RelationalModelDetector {
    JDBCReader reader;
    private TableSelectorStrategy tableSelector;
    private DatabaseCollector dbc;
    private Dialect dialect;
    private Mapping mapping;
    Table currentDbTable = null;

    @Override
    public String getName() {
        return "schema";
    }

    @Override
    public void initialize(Metadata metadata) {
        super.initialize(metadata);
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        StandardServiceRegistry serviceRegistry = builder.build();
        this.dialect = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect();
        this.tableSelector = new TableSelectorStrategy(new DefaultReverseEngineeringStrategy());
        this.reader = JDBCReaderFactory.newJDBCReader(Environment.getProperties(), this.tableSelector, (ServiceRegistry)serviceRegistry);
        this.dbc = new DefaultDatabaseCollector(this.reader.getMetaDataDialect());
    }

    @Override
    public void visit(IssueCollector collector) {
        super.visit(collector);
        this.visitGenerators(collector);
    }

    public void visitGenerators(IssueCollector collector) {
        Iterator<IdentifierGenerator> iter = this.iterateGenerators();
        Set<String> sequences = Collections.EMPTY_SET;
        if (this.dialect.supportsSequences()) {
            sequences = this.reader.readSequences(this.dialect.getQuerySequencesString());
        }
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            String key = this.getGeneratorKey(generator);
            if (this.isSequence(key, sequences) || this.isTable(key)) continue;
            collector.reportIssue(new Issue("MISSING_ID_GENERATOR", 100, "Missing sequence or table: " + key));
        }
    }

    private boolean isSequence(Object key, Set<?> sequences) {
        if (key instanceof String) {
            if (sequences.contains(key)) {
                return true;
            }
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 3) {
                return sequences.contains(strings[2]);
            }
            if (strings.length == 2) {
                return sequences.contains(strings[1]);
            }
        }
        return false;
    }

    private boolean isTable(Object key) throws HibernateException {
        if (key instanceof String) {
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 1) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(null, null, strings[0]));
                List<Table> list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
            if (strings.length == 3) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(strings[0], strings[1], strings[2]));
                List<Table> list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
            if (strings.length == 2) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(null, strings[0], strings[1]));
                List<Table> list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
        }
        return false;
    }

    @Override
    public void visit(Table table, IssueCollector pc) {
        if (table.isPhysicalTable()) {
            this.setSchemaSelection(table);
            List<Table> list = this.reader.readDatabaseSchema(this.dbc, null, null);
            if (list.isEmpty()) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 100, "Missing table " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName())));
                return;
            }
            if (list.size() > 1) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 50, "Found " + list.size() + " tables for " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName())));
                return;
            }
            this.currentDbTable = list.get(0);
            this.visitColumns(table, pc);
        }
    }

    String table(Table t) {
        return TableNameQualifier.qualify(t.getCatalog(), t.getSchema(), t.getName());
    }

    @Override
    public void visit(Table table, Column col, IssueCollector pc) {
        if (this.currentDbTable == null) {
            return;
        }
        Column dbColumn = this.currentDbTable.getColumn(new Column(col.getName()));
        if (dbColumn == null) {
            pc.reportIssue(new Issue("SCHEMA_COLUMN_MISSING", 100, this.table(table) + " is missing column: " + col.getName()));
        } else {
            int modelTypeCode;
            int dbTypeCode = dbColumn.getSqlTypeCode();
            if (dbTypeCode != (modelTypeCode = col.getSqlTypeCode(this.mapping))) {
                pc.reportIssue(new Issue("SCHEMA_COLUMN_TYPE_MISMATCH", 50, this.table(table) + " has a wrong column type for " + col.getName() + ", expected: " + JDBCToHibernateTypeHelper.getJDBCTypeName(modelTypeCode) + " but was " + JDBCToHibernateTypeHelper.getJDBCTypeName(dbTypeCode) + " in db"));
            }
        }
    }

    private void setSchemaSelection(Table table) {
        this.tableSelector.clearSchemaSelections();
        this.tableSelector.addSchemaSelection(new SchemaSelection(table.getCatalog(), table.getSchema(), table.getName()));
    }

    private Iterator<IdentifierGenerator> iterateGenerators() throws MappingException {
        TreeMap<String, IdentifierGenerator> generators = new TreeMap<String, IdentifierGenerator>();
        for (PersistentClass pc : this.getMetadata().getEntityBindings()) {
            IdentifierGenerator ig;
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), this.dialect, (RootClass)pc)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(this.getGeneratorKey((PersistentIdentifierGenerator)ig), ig);
        }
        for (Collection collection : this.getMetadata().getCollectionBindings()) {
            IdentifierGenerator ig;
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), this.dialect, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(this.getGeneratorKey((PersistentIdentifierGenerator)ig), ig);
        }
        return generators.values().iterator();
    }

    private IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getMetadata().getIdentifierGeneratorFactory();
    }

    private String getGeneratorKey(PersistentIdentifierGenerator ig) {
        String result = null;
        if (ig instanceof SequenceStyleGenerator) {
            result = this.getKeyForSequenceStyleGenerator((SequenceStyleGenerator)ig);
        } else if (ig instanceof TableGenerator) {
            result = this.getKeyForTableGenerator((TableGenerator)ig);
        }
        return result;
    }

    private String getKeyForSequenceStyleGenerator(SequenceStyleGenerator ig) {
        return ig.getDatabaseStructure().getPhysicalName().render();
    }

    private String getKeyForTableGenerator(TableGenerator ig) {
        return ig.getTableName();
    }
}

