/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tutorial.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.tutorial.util.HibernateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInterceptor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SessionInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.trace("===> opening session for request [" + request.hashCode() + "]");
        Session session = HibernateUtil.getSessionFactory().openSession();
        try {
            ManagedSessionContext.bind((Session)session);
            chain.doFilter(request, response);
        }
        finally {
            log.trace("===> cleaning-up session for request [" + request.hashCode() + "]");
            ManagedSessionContext.unbind((SessionFactory)HibernateUtil.getSessionFactory());
            try {
                session.close();
            }
            catch (Throwable t) {
                log.warn("was unable to properly close session for request [" + request.hashCode() + "]");
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

