/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;

public class InvalidValue
implements Serializable {
    private final String message;
    private final Object value;
    private final String propertyName;
    private final Class beanClass;
    private final Object bean;
    private Object rootBean;
    private String propertyPath;

    public Object getRootBean() {
        return this.rootBean;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public InvalidValue(String message, Class beanClass, String propertyName, Object value, Object bean) {
        this.message = message;
        this.value = value;
        this.beanClass = beanClass;
        this.propertyName = propertyName;
        this.bean = bean;
        this.rootBean = bean;
        this.propertyPath = propertyName;
    }

    public void addParentBean(Object parentBean, String propertyName) {
        this.rootBean = parentBean;
        this.propertyPath = propertyName + "." + this.propertyPath;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getBean() {
        return this.bean;
    }

    public String toString() {
        return this.propertyName + ' ' + this.message;
    }
}

