/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.AmbiguousConstraintUsageException;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.UnexpectedTypeForConstraintException;
import javax.validation.ValidationException;
import org.hibernate.validation.engine.ConstraintValidatorContextImpl;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree {
    private static final Logger log = LoggerFactory.make();
    private final ConstraintTree parent;
    private final List<ConstraintTree> children;
    private final ConstraintDescriptor descriptor;

    public ConstraintTree(ConstraintDescriptor descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptor descriptor, ConstraintTree parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        this.children = new ArrayList<ConstraintTree>(descriptor.getComposingConstraints().size());
        for (ConstraintDescriptor composingDescriptor : descriptor.getComposingConstraints()) {
            ConstraintTree treeNode = new ConstraintTree(composingDescriptor, this);
            this.children.add(treeNode);
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ConstraintTree getParent() {
        return this.parent;
    }

    public List<ConstraintTree> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public ConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void validateConstraints(Object value, Class beanClass, ExecutionContext executionContext) {
        ConstraintValidator validator;
        for (ConstraintTree tree : this.getChildren()) {
            tree.validateConstraints(value, beanClass, executionContext);
        }
        Object leafBeanInstance = executionContext.peekValidatedObject();
        ConstraintValidatorContextImpl constraintContext = new ConstraintValidatorContextImpl(this.descriptor);
        if (log.isTraceEnabled()) {
            log.trace("Validating value {} against constraint defined by {}", value, (Object)this.descriptor);
        }
        if (!(validator = this.getInitalizedValidator(value, executionContext.getConstraintValidatorFactory())).isValid(value, (ConstraintValidatorContext)constraintContext)) {
            for (ConstraintValidatorContextImpl.ErrorMessage error : constraintContext.getErrorMessages()) {
                String message = error.getMessage();
                this.createConstraintViolation(value, beanClass, executionContext, leafBeanInstance, message, this.descriptor);
            }
        }
        if (this.reportAsSingleViolation() && executionContext.getFailingConstraints().size() > 0) {
            executionContext.clearFailingConstraints();
            String message = (String)this.getParent().getDescriptor().getParameters().get("message");
            this.createConstraintViolation(value, beanClass, executionContext, leafBeanInstance, message, this.getParent().descriptor);
        }
    }

    private boolean reportAsSingleViolation() {
        return this.getParent() != null && this.getParent().getDescriptor().isReportAsSingleViolation();
    }

    private <T> void createConstraintViolation(Object value, Class<T> beanClass, ExecutionContext<T> executionContext, Object leafBeanInstance, String message, ConstraintDescriptor descriptor) {
        String interpolatedMessage = executionContext.getMessageResolver().interpolate(message, descriptor, leafBeanInstance);
        ConstraintViolationImpl<T> failingConstraintViolation = new ConstraintViolationImpl<T>(message, interpolatedMessage, executionContext.getRootBean(), beanClass, leafBeanInstance, value, executionContext.peekPropertyPath(), executionContext.getCurrentGroup(), descriptor);
        executionContext.addConstraintFailure(failingConstraintViolation);
    }

    private ConstraintValidator getInitalizedValidator(Object value, ConstraintValidatorFactory constraintFactory) {
        Class validatorClass = value == null ? (Class)this.descriptor.getConstraintValidatorClasses().get(0) : this.findMatchingValidatorClass(value);
        ConstraintValidator constraintValidator = constraintFactory.getInstance(validatorClass);
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class findMatchingValidatorClass(Object value) {
        Class valueClass = this.determineValueClass(value);
        Map<Class<?>, Class<ConstraintValidator<Annotation, ?>>> validatorsTypes = ValidatorTypeHelper.getValidatorsTypes(this.descriptor.getConstraintValidatorClasses());
        List<Class> assignableClasses = this.findAssingableClasses(valueClass, validatorsTypes);
        this.resolveAssignableClasses(assignableClasses);
        this.verifyResolveWasUnique(valueClass, assignableClasses);
        return validatorsTypes.get(assignableClasses.get(0));
    }

    private void verifyResolveWasUnique(Class valueClass, List<Class> assignableClasses) {
        if (assignableClasses.size() == 0) {
            throw new UnexpectedTypeForConstraintException("No validator could be found for type: " + valueClass.getName());
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validators which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Class clazz : assignableClasses) {
                builder.append(clazz.getName());
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new AmbiguousConstraintUsageException(builder.toString());
        }
    }

    private List<Class> findAssingableClasses(Class valueClass, Map<Class<?>, Class<? extends ConstraintValidator<? extends Annotation, ?>>> validatorsTypes) {
        ArrayList<Class> assignableClasses = new ArrayList<Class>();
        for (Class<?> clazz : validatorsTypes.keySet()) {
            if (!clazz.isAssignableFrom(valueClass)) continue;
            assignableClasses.add(clazz);
        }
        return assignableClasses;
    }

    private Class determineValueClass(Object value) {
        Class<Object> valueClass = value.getClass();
        if (valueClass.isArray()) {
            valueClass = Array.class;
        }
        return valueClass;
    }

    private void resolveAssignableClasses(List<Class> assignableClasses) {
        if (assignableClasses.size() == 0 || assignableClasses.size() == 1) {
            return;
        }
        ArrayList<Class> classesToRemove = new ArrayList<Class>();
        do {
            classesToRemove.clear();
            Class clazz = assignableClasses.get(0);
            for (int i = 1; i < assignableClasses.size(); ++i) {
                if (clazz.isAssignableFrom(assignableClasses.get(i))) {
                    classesToRemove.add(clazz);
                    continue;
                }
                if (!assignableClasses.get(i).isAssignableFrom(clazz)) continue;
                classesToRemove.add(assignableClasses.get(i));
            }
            assignableClasses.removeAll(classesToRemove);
        } while (classesToRemove.size() > 0);
    }

    private void initializeConstraint(ConstraintDescriptor descriptor, ConstraintValidator constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to intialize " + constraintValidator.getClass().getName(), (Throwable)e);
        }
    }
}

