/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.validation.ConstraintDescriptor;
import javax.validation.ValidationException;
import org.hibernate.validation.engine.ConstraintTree;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaConstraint {
    private final ConstraintTree constraintTree;
    private final Type type;
    private final Method method;
    private final Field field;
    private final String propertyName;
    private final ElementType elementType;

    public MetaConstraint(Type t, ConstraintDescriptor constraintDescriptor) {
        this(t, null, null, ElementType.FIELD, constraintDescriptor, "");
    }

    public MetaConstraint(Method m, ConstraintDescriptor constraintDescriptor) {
        this(null, m, null, ElementType.METHOD, constraintDescriptor, ReflectionHelper.getPropertyName(m));
    }

    public MetaConstraint(Field f, ConstraintDescriptor constraintDescriptor) {
        this(null, null, f, ElementType.FIELD, constraintDescriptor, f.getName());
    }

    private MetaConstraint(Type t, Method m, Field f, ElementType elementType, ConstraintDescriptor constraintDescriptor, String property) {
        this.type = t;
        this.method = m;
        this.field = f;
        this.elementType = elementType;
        this.propertyName = property;
        this.constraintTree = new ConstraintTree(constraintDescriptor);
    }

    public Object getValue(Object o) {
        switch (this.elementType) {
            case TYPE: {
                return o;
            }
            case METHOD: {
                return ReflectionHelper.getValue(this.method, o);
            }
            case FIELD: {
                return ReflectionHelper.getValue(this.field, o);
            }
        }
        throw new ValidationException("Invalid state of MetaConstraint. Parameter elementType has unexpected value - " + (Object)((Object)this.elementType));
    }

    public boolean isCollection() {
        Type t = this.typeOfAnnoatedElement();
        return ReflectionHelper.isCollection(t);
    }

    public boolean isArray() {
        Type t = this.typeOfAnnoatedElement();
        return ReflectionHelper.isArray(t);
    }

    public ConstraintDescriptor getDescriptor() {
        return this.constraintTree.getDescriptor();
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ConstraintTree getConstraintTree() {
        return this.constraintTree;
    }

    public <T> void validateConstraint(Class beanClass, ExecutionContext<T> executionContext) {
        Object leafBeanInstance = executionContext.peekValidatedObject();
        Object value = this.getValue(leafBeanInstance);
        this.constraintTree.validateConstraints(value, beanClass, executionContext);
    }

    public <T> void validateConstraint(Class beanClass, Object value, ExecutionContext<T> executionContext) {
        this.constraintTree.validateConstraints(value, beanClass, executionContext);
    }

    private Type typeOfAnnoatedElement() {
        Type t;
        switch (this.elementType) {
            case TYPE: {
                t = this.type;
                break;
            }
            case METHOD: {
                t = ReflectionHelper.typeOf(this.method);
                break;
            }
            case FIELD: {
                t = ReflectionHelper.typeOf(this.field);
                break;
            }
            default: {
                throw new ValidationException("Invalid state of MetaConstraint. Parameter elementType has unexpected value - " + (Object)((Object)this.elementType));
            }
        }
        return t;
    }
}

