/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import org.hibernate.validation.engine.BuiltinConstraints;
import org.hibernate.validation.engine.ValidatorImpl;

public class ValidatorContextImpl
implements ValidatorContext {
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private final MessageInterpolator factoryMessageInterpolator;
    private final TraversableResolver factoryTraversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final BuiltinConstraints builtinConstraints;

    public ValidatorContextImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator factoryMessageInterpolator, TraversableResolver factoryTraversableResolver, BuiltinConstraints builtinConstraints) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.factoryMessageInterpolator = factoryMessageInterpolator;
        this.factoryTraversableResolver = factoryTraversableResolver;
        this.builtinConstraints = builtinConstraints;
        this.messageInterpolator(factoryMessageInterpolator);
        this.traversableResolver(factoryTraversableResolver);
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.factoryMessageInterpolator : messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.factoryTraversableResolver : traversableResolver;
        return this;
    }

    public Validator getValidator() {
        return new ValidatorImpl(this.constraintValidatorFactory, this.messageInterpolator, this.builtinConstraints);
    }
}

