/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Digits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigitsValidatorForNumber
implements ConstraintValidator<Digits, Number> {
    private int maxIntegerLength;
    private int maxFractionLength;

    public void initialize(Digits constraintAnnotation) {
        this.maxIntegerLength = constraintAnnotation.integer();
        this.maxFractionLength = constraintAnnotation.fraction();
    }

    public boolean isValid(Number num, ConstraintValidatorContext constraintValidatorContext) {
        if (num == null) {
            return true;
        }
        BigDecimal bigNum = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString());
        int integerPartLength = bigNum.precision() - bigNum.scale();
        int fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
        return this.maxIntegerLength >= integerPartLength && this.maxFractionLength >= fractionPartLength;
    }
}

