/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.DefaultValidationProviderResolver;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validation.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validation.engine.DefaultTraversableResolver;
import org.hibernate.validation.engine.HibernateValidatorConfiguration;
import org.hibernate.validation.engine.ResourceBundleMessageInterpolator;
import org.hibernate.validation.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final MessageInterpolator defaultMessageInterpolator;
    private static final TraversableResolver defaultTraversableResolver;
    private MessageInterpolator messageInterpolator;
    private ConstraintValidatorFactory constraintValidatorFactory = new ConstraintValidatorFactoryImpl();
    private String configurationFile = "META-INF/validation.xml";
    private final ValidationProvider provider;
    private final ValidationProviderResolver providerResolver;
    private TraversableResolver traversableResolver;
    private boolean ignoreXmlConfiguration;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? new DefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.provider = null;
        this.messageInterpolator = defaultMessageInterpolator;
        this.traversableResolver = defaultTraversableResolver;
    }

    public ConfigurationImpl(ValidationProvider provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.provider = provider;
        this.providerResolver = null;
        this.messageInterpolator = defaultMessageInterpolator;
        this.traversableResolver = defaultTraversableResolver;
    }

    public HibernateValidatorConfiguration ignoreXmlConfiguration() {
        return null;
    }

    public ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.messageInterpolator = interpolator;
        return this;
    }

    public ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.traversableResolver = resolver;
        return this;
    }

    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public HibernateValidatorConfiguration addMapping(InputStream stream) {
        return null;
    }

    public HibernateValidatorConfiguration addProperty(String name, String value) {
        return null;
    }

    public ValidatorFactory buildValidatorFactory() {
        if (this.isSpecificProvider()) {
            return this.provider.buildValidatorFactory((ConfigurationState)this);
        }
        Class providerClass = null;
        if (providerClass != null) {
            for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
                if (!provider.isSuitable(providerClass)) continue;
                return provider.buildValidatorFactory((ConfigurationState)this);
            }
            throw new ValidationException("Unable to find provider: " + providerClass);
        }
        List providers = this.providerResolver.getValidationProviders();
        assert (providers.size() != 0);
        return ((ValidationProvider)providers.get(0)).buildValidatorFactory((ConfigurationState)this);
    }

    private boolean isSpecificProvider() {
        return this.provider != null;
    }

    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public Set<InputStream> getMappingStreams() {
        throw new UnsupportedOperationException("TODO");
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException("TODO");
    }

    public MessageInterpolator getDefaultMessageInterpolator() {
        return defaultMessageInterpolator;
    }

    static {
        Version.touch();
        defaultMessageInterpolator = new ResourceBundleMessageInterpolator();
        defaultTraversableResolver = new DefaultTraversableResolver();
    }
}

