/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.BeanDescriptor;
import javax.validation.GroupSequence;
import javax.validation.PropertyDescriptor;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BeanDescriptorImpl;
import org.hibernate.validation.engine.BeanMetaData;
import org.hibernate.validation.engine.ConstraintDescriptorImpl;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.engine.PropertyDescriptorImpl;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private List<MetaConstraint<T, ?>> metaConstraintList = new ArrayList();
    private List<Field> cascadedFields = new ArrayList<Field>();
    private List<Method> cascadedMethods = new ArrayList<Method>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData();
    }

    private void createMetaData() {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence(this.beanClass);
        ArrayList<Class> classes = new ArrayList<Class>();
        this.computeClassHierarchy(this.beanClass, classes);
        for (Class current : classes) {
            this.initClass(current);
        }
    }

    private void computeClassHierarchy(Class clazz, List<Class> classes) {
        if (log.isTraceEnabled()) {
            log.trace("Processing: {}", (Object)clazz);
        }
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private void initClass(Class clazz) {
        this.initClassConstraints(clazz);
        this.initMethodConstraints(clazz);
        this.initFieldConstraints(clazz);
    }

    private void initDefaultGroupSequence(Class<?> clazz) {
        GroupSequence groupSequenceAnnotation = clazz.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            this.defaultGroupSequence.add(Default.class);
        } else {
            List<Class> groupSequenceList = Arrays.asList(groupSequenceAnnotation.value());
            for (Class group : groupSequenceList) {
                if (group.getName().equals(clazz.getName())) {
                    this.defaultGroupSequence.add(Default.class);
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw new ValidationException("'Default.class' cannot appear in default group sequence list.");
                }
                this.defaultGroupSequence.add(group);
            }
            if (log.isDebugEnabled()) {
                log.debug("Bean {} redefines the Default group. Members of the default group sequence are: {}", (Object)clazz.getName(), this.defaultGroupSequence);
            }
        }
    }

    private <A extends Annotation> void initFieldConstraints(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            List<ConstraintDescriptorImpl> fieldMetadata = this.findConstraints(field);
            for (ConstraintDescriptorImpl constraintDescription : fieldMetadata) {
                ReflectionHelper.setAccessibility(field);
                MetaConstraint metaConstraint = new MetaConstraint(field, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!field.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(field);
            this.cascadedFields.add(field);
            this.addPropertyDescriptorForMember(field);
        }
    }

    private <A extends Annotation> void initMethodConstraints(Class clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            List<ConstraintDescriptorImpl> methodMetadata = this.findConstraints(method);
            for (ConstraintDescriptorImpl constraintDescription : methodMetadata) {
                ReflectionHelper.setAccessibility(method);
                MetaConstraint metaConstraint = new MetaConstraint(method, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!method.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(method);
            this.cascadedMethods.add(method);
            this.addPropertyDescriptorForMember(method);
        }
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class), name);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private <A extends Annotation> void initClassConstraints(Class clazz) {
        List<ConstraintDescriptorImpl> classMetadata = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl constraintDescription : classMetadata) {
            MetaConstraint metaConstraint = new MetaConstraint(clazz, constraintDescription);
            this.metaConstraintList.add(metaConstraint);
        }
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl> findConstraintAnnotations(Class<?> clazz, A annotation) {
        ArrayList<ConstraintDescriptorImpl> constraintDescriptors = new ArrayList<ConstraintDescriptorImpl>();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        if (this.constraintHelper.isConstraintAnnotation(annotation) || this.constraintHelper.isBuiltinConstraint(annotation)) {
            constraints.add(annotation);
        }
        constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(Class<?> clazz, A annotation) {
        Class[] groups = ReflectionHelper.getAnnotationParameter(annotation, "groups", Class[].class);
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() ? new ConstraintDescriptorImpl<A>(annotation, groups, this.constraintHelper, clazz) : new ConstraintDescriptorImpl<A>(annotation, groups, this.constraintHelper);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(beanClass, annotation));
        }
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            this.beanDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    private List<ConstraintDescriptorImpl> findConstraints(Member member) {
        assert (member instanceof Field || member instanceof Method);
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : ((AnnotatedElement)((Object)member)).getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation));
        }
        String name = ReflectionHelper.getPropertyName(member);
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            if (member instanceof Method && name == null) {
                throw new ValidationException("Annotated methods must follow the JavaBeans naming convention. " + member.getName() + "() does not.");
            }
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
            if (propertyDescriptor == null) {
                propertyDescriptor = this.addPropertyDescriptorForMember(member);
            }
            propertyDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Field> getCascadedFields() {
        return this.cascadedFields;
    }

    @Override
    public List<Method> getCascadedMethods() {
        return this.cascadedMethods;
    }

    @Override
    public List<Member> getCascadedMembers() {
        ArrayList<Member> cascadedMembers = new ArrayList<Member>();
        cascadedMembers.addAll(this.getCascadedFields());
        cascadedMembers.addAll(this.getCascadedMethods());
        return cascadedMembers;
    }

    @Override
    public List<MetaConstraint<T, ?>> geMetaConstraintList() {
        return this.metaConstraintList;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return this.defaultGroupSequence;
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }
}

