/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationProviderResolver
implements ValidationProviderResolver {
    private static final Map<ClassLoader, List<ValidationProvider>> providersPerClassloader = new WeakHashMap<ClassLoader, List<ValidationProvider>>();
    private static final String SERVICES_FILE = "META-INF/services/" + ValidationProvider.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ValidationProvider> getValidationProviders() {
        List<ValidationProvider> providers;
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = DefaultValidationProviderResolver.class.getClassLoader();
        }
        Map<ClassLoader, List<ValidationProvider>> map = providersPerClassloader;
        synchronized (map) {
            providers = providersPerClassloader.get(classloader);
        }
        if (providers == null) {
            providers = new ArrayList<ValidationProvider>();
            String name = null;
            try {
                Enumeration<URL> providerDefinitions = classloader.getResources(SERVICES_FILE);
                while (providerDefinitions.hasMoreElements()) {
                    URL url = providerDefinitions.nextElement();
                    InputStream stream = url.openStream();
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
                        name = reader.readLine();
                        while (name != null) {
                            if (!(name = name.trim()).startsWith("#")) {
                                Class<?> providerClass = DefaultValidationProviderResolver.loadClass(name, DefaultValidationProviderResolver.class);
                                providers.add((ValidationProvider)providerClass.newInstance());
                            }
                            name = reader.readLine();
                        }
                    }
                    finally {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to read " + SERVICES_FILE, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ValidationException("Unable to load Bean Validation provider " + name, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to instanciate Bean Validation provider" + name, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ValidationException("Unable to instanciate Bean Validation provider" + name, (Throwable)e);
            }
            Map<ClassLoader, List<ValidationProvider>> map2 = providersPerClassloader;
            synchronized (map2) {
                providersPerClassloader.put(classloader, providers);
            }
        }
        return providers;
    }

    private static Class<?> loadClass(String name, Class caller) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                if (caller != null) break block3;
                throw e;
            }
        }
        return Class.forName(name, true, caller.getClassLoader());
    }
}

