/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine.groups;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.validation.engine.groups.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupChain {
    private List<Group> groupList = new ArrayList<Group>();
    private List<List<Group>> sequenceList = new ArrayList<List<Group>>();

    public Iterator<Group> getGroupIterator() {
        return this.groupList.iterator();
    }

    public Iterator<List<Group>> getSequenceIterator() {
        return this.sequenceList.iterator();
    }

    public boolean containsSequence(Class<?> groupSequence) {
        boolean result = false;
        for (List<Group> sequence : this.sequenceList) {
            if (!sequence.get(0).getSequence().getName().equals(groupSequence.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    void insertGroup(Group group) {
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
    }

    void insertSequence(List<Group> groups) {
        if (groups == null || groups.size() == 0) {
            return;
        }
        if (!this.sequenceList.contains(groups)) {
            this.sequenceList.add(groups);
        }
    }
}

