/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.util;

public class PropertyIterator {
    final String originalProperty;
    String head;
    String index;
    String tail;

    public PropertyIterator(String property) {
        this.originalProperty = property;
        this.tail = "".equals(property) ? null : property;
    }

    public boolean hasNext() {
        return this.tail != null;
    }

    public void split() {
        if (this.tail == null) {
            return;
        }
        String[] tokens = this.tail.split("\\.", 2);
        this.head = tokens[0];
        this.index = null;
        if (this.head.contains("[")) {
            this.head = tokens[0].substring(0, tokens[0].indexOf("["));
            this.index = tokens[0].substring(tokens[0].indexOf("[") + 1, tokens[0].indexOf("]"));
        }
        this.tail = tokens.length > 1 ? tokens[1] : null;
    }

    public String getOriginalProperty() {
        return this.originalProperty;
    }

    public String getHead() {
        return this.head;
    }

    public String getTail() {
        return this.tail;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isIndexed() {
        return this.index != null;
    }
}

