/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.hibernate.validation.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.hibernate.validation.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Logger log = LoggerFactory.make();
    private static final Pattern messageParameterPattern = Pattern.compile("(\\{[\\w\\.]+\\})");
    private final Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();

    public ResourceBundleMessageInterpolator() {
        this(null);
    }

    public ResourceBundleMessageInterpolator(ResourceBundle resourceBundle) {
        this.defaultLocale = Locale.getDefault();
        if (resourceBundle == null) {
            ResourceBundle bundle = this.getFileBasedResourceBundle(this.defaultLocale);
            if (bundle != null) {
                this.userBundlesMap.put(this.defaultLocale, bundle);
            }
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        this.defaultBundlesMap.put(this.defaultLocale, ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, this.defaultLocale));
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), locale);
    }

    private String interpolateMessage(String message, Map<String, Object> annotationParameters, Locale locale) {
        ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
        ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
        String resolvedMessage = message;
        boolean evaluatedDefaultBundleOnce = false;
        while (true) {
            String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
            if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
            resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
            evaluatedDefaultBundleOnce = true;
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        resolvedMessage = resolvedMessage.replace("\\{", "{");
        resolvedMessage = resolvedMessage.replace("\\}", "}");
        resolvedMessage = resolvedMessage.replace("\\\\", "\\");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by thread local classloader");
        }
        if (rb == null) {
            rb = this.loadBundle(this.getClass().getClassLoader(), locale, "ValidationMessages not found by validator classloader");
        }
        if (log.isDebugEnabled()) {
            if (rb != null) {
                log.debug("ValidationMessages found");
            } else {
                log.debug("ValidationMessages not found. Delegating to org.hibernate.validation.ValidationMessages");
            }
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }

    private String replaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String resolvedParameterValue = this.resolveParameter(parameter, bundle, locale, recurse);
            matcher.appendReplacement(sb, this.escapeMetaCharacters(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(this.removeCurlyBrace(parameter));
            String resolvedParameterValue = variable != null ? this.escapeMetaCharacters(variable.toString()) : parameter;
            matcher.appendReplacement(sb, resolvedParameterValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBrace(parameterName));
                if (recurse) {
                    parameterValue = this.replaceVariables(parameterValue, bundle, locale, recurse);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        if (this.defaultBundlesMap.containsKey(locale)) {
            return this.defaultBundlesMap.get(locale);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale);
        this.defaultBundlesMap.put(locale, bundle);
        return bundle;
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        if (this.userBundlesMap.containsKey(locale)) {
            return this.userBundlesMap.get(locale);
        }
        ResourceBundle bundle = this.getFileBasedResourceBundle(locale);
        if (bundle != null) {
            this.userBundlesMap.put(locale, bundle);
        }
        return bundle;
    }

    private String escapeMetaCharacters(String s) {
        String escapedString = s.replace("\\", "\\\\");
        escapedString = escapedString.replace("$", "\\$");
        return escapedString;
    }
}

