/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import org.hibernate.validation.engine.groups.Group;
import org.hibernate.validation.engine.groups.GroupChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupChainGenerator {
    private final Map<Class<?>, List<Group>> resolvedSequences = new HashMap();

    public GroupChain getGroupChainFor(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one groups has to be specified.");
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw new ValidationException("A group has to be an interface. " + clazz.getName() + " is not.");
        }
        GroupChain chain = new GroupChain();
        for (Class<?> clazz : groups) {
            if (clazz.getAnnotation(GroupSequence.class) == null) {
                Group group = new Group(clazz);
                chain.insertGroup(group);
                this.insertInheritedGroups(clazz, chain);
                continue;
            }
            this.insertSequence(clazz, chain);
        }
        return chain;
    }

    private void insertInheritedGroups(Class<?> clazz, GroupChain chain) {
        for (Class<?> extendedInterface : clazz.getInterfaces()) {
            Group group = new Group(extendedInterface);
            chain.insertGroup(group);
            this.insertInheritedGroups(extendedInterface, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupChain chain) {
        List<Group> sequence = this.resolvedSequences.containsKey(clazz) ? this.resolvedSequences.get(clazz) : this.resolveSequence(clazz, new ArrayList());
        chain.insertSequence(sequence);
    }

    private List<Group> resolveSequence(Class<?> group, List<Class<?>> processedSequences) {
        Class[] sequenceArray;
        if (processedSequences.contains(group)) {
            throw new GroupDefinitionException("Cyclic dependency in groups definition");
        }
        processedSequences.add(group);
        ArrayList<Group> resolvedGroupSequence = new ArrayList<Group>();
        GroupSequence sequenceAnnotation = group.getAnnotation(GroupSequence.class);
        for (Class clazz : sequenceArray = sequenceAnnotation.value()) {
            if (clazz.getAnnotation(GroupSequence.class) == null) {
                resolvedGroupSequence.add(new Group(clazz, group));
                continue;
            }
            List<Group> tmpSequence = this.resolveSequence(clazz, processedSequences);
            resolvedGroupSequence.addAll(tmpSequence);
        }
        this.resolvedSequences.put(group, resolvedGroupSequence);
        return resolvedGroupSequence;
    }
}

