/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints.impl;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import org.hibernate.validation.constraints.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthValidator
implements ConstraintValidator<Length, String> {
    private int min;
    private int max;

    public void initialize(Length parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.validateParameters();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        int length = value.length();
        return length >= this.min && length <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new ValidationException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new ValidationException("The max paramter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new ValidationException("The length cannot be negative.");
        }
    }
}

