/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validation.engine.ConstraintValidatorContextImpl;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.GlobalExecutionContext;
import org.hibernate.validation.engine.LocalExecutionContext;
import org.hibernate.validation.jtype.TypeUtils;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree<A extends Annotation> {
    private static final Logger log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptor<A> descriptor;
    private final Map<Class<? extends ConstraintValidator<?, ?>>, ConstraintValidator<A, ?>> constraintValidatorCache;

    public ConstraintTree(ConstraintDescriptor<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptor<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        this.constraintValidatorCache = new HashMap();
        Set composingConstraints = descriptor.getComposingConstraints();
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptor composingDescriptor : composingConstraints) {
            ConstraintTree treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptor<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ConstraintTree getParent() {
        return this.parent;
    }

    public List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public ConstraintDescriptor<A> getDescriptor() {
        return this.descriptor;
    }

    public <T, U, V> void validateConstraints(Type type, GlobalExecutionContext<T> executionContext, LocalExecutionContext<U, V> localExecutionContext, List<ConstraintViolation<T>> constraintViolations) {
        for (ConstraintTree<?> tree : this.getChildren()) {
            ArrayList<ConstraintViolation<T>> tmpViolations = new ArrayList<ConstraintViolation<T>>();
            tree.validateConstraints(type, executionContext, localExecutionContext, tmpViolations);
            constraintViolations.addAll(tmpViolations);
        }
        ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(localExecutionContext.getPropertyPath(), this.descriptor);
        if (!this.descriptor.getConstraintValidatorClasses().isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Validating value {} against constraint defined by {}", localExecutionContext.getCurrentValidatedValue(), this.descriptor);
            }
            ConstraintValidator<A, V> validator = this.getInitalizedValidator(localExecutionContext.getCurrentValidatedValue(), type, executionContext.getConstraintValidatorFactory());
            this.validateSingleConstraint(executionContext, localExecutionContext, constraintViolations, constraintValidatorContext, validator);
        }
        if (this.reportAsSingleViolation() && constraintViolations.size() > 0) {
            constraintViolations.clear();
            String message = (String)this.getDescriptor().getAttributes().get("message");
            ConstraintValidatorContextImpl constraintValidatorContextImpl = constraintValidatorContext;
            constraintValidatorContextImpl.getClass();
            ConstraintValidatorContextImpl.ErrorMessage error = new ConstraintValidatorContextImpl.ErrorMessage(constraintValidatorContextImpl, message, localExecutionContext.getPropertyPath());
            ConstraintViolationImpl<T> violation = executionContext.createConstraintViolation(localExecutionContext, error, this.descriptor);
            constraintViolations.add(violation);
        }
    }

    private <T, U, V> void validateSingleConstraint(GlobalExecutionContext<T> executionContext, LocalExecutionContext<U, V> localExecutionContext, List<ConstraintViolation<T>> constraintViolations, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator) {
        boolean isValid;
        try {
            isValid = validator.isValid(localExecutionContext.getCurrentValidatedValue(), (ConstraintValidatorContext)constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unexpected exception during isValid call", (Throwable)e);
        }
        if (!isValid) {
            constraintViolations.addAll(executionContext.createConstraintViolations(localExecutionContext, constraintValidatorContext));
        }
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation();
    }

    private <V> ConstraintValidator<A, V> getInitalizedValidator(V value, Type type, ConstraintValidatorFactory constraintFactory) {
        ConstraintValidator<A, ?> constraintValidator;
        Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(value, type);
        if (!this.constraintValidatorCache.containsKey(validatorClass)) {
            constraintValidator = constraintFactory.getInstance(validatorClass);
            if (constraintValidator == null) {
                throw new ValidationException("Constraint factory returned null when trying to create instance of " + validatorClass.getName());
            }
            this.constraintValidatorCache.put(validatorClass, constraintValidator);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Constraint validator {} found in cache");
            }
            constraintValidator = this.constraintValidatorCache.get(validatorClass);
        }
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Object value, Type type) {
        Map<Type, Class<ConstraintValidator<?, ?>>> validatorsTypes = ValidatorTypeHelper.getValidatorsTypes(this.descriptor.getConstraintValidatorClasses());
        ArrayList<Type> suitableTypes = new ArrayList<Type>();
        this.findSuitableValidatorTypes(type, validatorsTypes, suitableTypes);
        if (value != null) {
            this.findSuitableValidatorTypes(value.getClass(), validatorsTypes, suitableTypes);
        }
        this.resolveAssignableTypes(suitableTypes);
        this.verifyResolveWasUnique(type, suitableTypes);
        return validatorsTypes.get(suitableTypes.get(0));
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            throw new UnexpectedTypeException("No validator could be found for type: " + valueClass);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validators which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new UnexpectedTypeException(builder.toString());
        }
    }

    private void findSuitableValidatorTypes(Type type, Map<Type, Class<? extends ConstraintValidator<?, ?>>> validatorsTypes, List<Type> suitableTypes) {
        for (Type validatorType : validatorsTypes.keySet()) {
            if (!TypeUtils.isAssignable(validatorType, type) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeUtils.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeUtils.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private <V> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, V> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to intialize " + constraintValidator.getClass().getName(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append(", constraintValidatorCache=").append(this.constraintValidatorCache);
        sb.append('}');
        return sb.toString();
    }
}

