/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.xml;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validation.util.GetClassLoader;
import org.hibernate.validation.util.LoadClass;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.NewInstance;
import org.hibernate.validation.xml.PropertyType;
import org.hibernate.validation.xml.ValidationBootstrapParameters;
import org.hibernate.validation.xml.ValidationConfigType;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationXmlParser {
    private static final Logger log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";

    public ValidationBootstrapParameters parseValidationXml() {
        ValidationConfigType config = this.getValidationConfig();
        ValidationBootstrapParameters xmlParameters = new ValidationBootstrapParameters();
        if (config != null) {
            this.setProviderClassFromXml(config, xmlParameters);
            this.setMessageInterpolatorFromXml(config, xmlParameters);
            this.setTraversableResolverFromXml(config, xmlParameters);
            this.setConstraintFactoryFromXml(config, xmlParameters);
            this.setMappingStreamsFromXml(config, xmlParameters);
            this.setPropertiesFromXml(config, xmlParameters);
        }
        return xmlParameters;
    }

    private void setConstraintFactoryFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String constraintFactoryClass = config.getConstraintValidatorFactory();
        if (constraintFactoryClass != null) {
            try {
                Class<?> clazz = this.loadClass(constraintFactoryClass, this.getClass());
                NewInstance<?> newInstance = NewInstance.action(clazz, "constraint factory class");
                xmlParameters.constraintValidatorFactory = System.getSecurityManager() != null ? (ConstraintValidatorFactory)AccessController.doPrivileged(newInstance) : (ConstraintValidatorFactory)newInstance.run();
                log.info("Using {} as constraint factory.", (Object)constraintFactoryClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate constraint factory class " + constraintFactoryClass + ".", (Throwable)e);
            }
        }
    }

    private Class<?> loadClass(String className, Class<?> caller) {
        LoadClass action = LoadClass.action(className, caller);
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    private void setPropertiesFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debug("Found property '{}' with value '{}' in validation.xml.", (Object)property.getName(), (Object)property.getValue());
            }
            xmlParameters.configProperties.put(property.getName(), property.getValue());
        }
    }

    private void setMappingStreamsFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (JAXBElement<String> mappingFileName : config.getConstraintMapping()) {
            InputStream in;
            if (log.isDebugEnabled()) {
                log.debug("Trying to open input stream for {}.", mappingFileName.getValue());
            }
            if ((in = this.getInputStreamForPath((String)mappingFileName.getValue())) == null) {
                throw new ValidationException("Unable to open input stream for mapping file " + (String)mappingFileName.getValue() + ".");
            }
            xmlParameters.mappings.add(in);
        }
    }

    private void setMessageInterpolatorFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String messageInterpolatorClass = config.getMessageInterpolator();
        if (messageInterpolatorClass != null) {
            try {
                Class<?> clazz = this.loadClass(messageInterpolatorClass, this.getClass());
                xmlParameters.messageInterpolator = (MessageInterpolator)clazz.newInstance();
                log.info("Using {} as message interpolator.", (Object)messageInterpolatorClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
        }
    }

    private void setTraversableResolverFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String traversableResolverClass = config.getTraversableResolver();
        if (traversableResolverClass != null) {
            try {
                Class<?> clazz = this.loadClass(traversableResolverClass, this.getClass());
                xmlParameters.traversableResolver = (TraversableResolver)clazz.newInstance();
                log.info("Using {} as traversable resolver.", (Object)traversableResolverClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
        }
    }

    private void setProviderClassFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParamters) {
        String providerClassName = config.getDefaultProvider();
        if (providerClassName != null) {
            try {
                xmlParamters.providerClass = this.loadClass(providerClassName, this.getClass());
                log.info("Using {} as validation provider.", (Object)providerClassName);
            }
            catch (Exception e) {
                throw new ValidationException("Unable to instantiate validation provider class " + providerClassName + ".");
            }
        }
    }

    private ValidationConfigType getValidationConfig() {
        ValidationConfigType validationConfig;
        InputStream inputStream = this.getInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream == null) {
            log.debug("No {} found. Using annotation based configuration only", (Object)VALIDATION_XML_FILE);
            return null;
        }
        log.info("{} found.", (Object)VALIDATION_XML_FILE);
        Schema schema = this.getValidationConfigurationSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            validationConfig = (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            log.error("Error parsing validation.xml: {}", (Object)e.getMessage());
            throw new ValidationException("Unable to parse META-INF/validation.xml");
        }
        return validationConfig;
    }

    private InputStream getInputStreamForPath(String path) {
        ClassLoader loader;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        boolean isSecured = System.getSecurityManager() != null;
        boolean isContextCL = true;
        GetClassLoader action = GetClassLoader.fromContext();
        ClassLoader classLoader = loader = isSecured ? AccessController.doPrivileged(action) : action.run();
        if (loader == null) {
            log.debug("No default context class loader, fallbacking to Bean Validation's loader");
            action = GetClassLoader.fromClass(ValidationXmlParser.class);
            loader = isSecured ? AccessController.doPrivileged(action) : action.run();
            isContextCL = false;
        }
        InputStream inputStream = loader.getResourceAsStream(path);
        if (isContextCL && inputStream == null) {
            action = GetClassLoader.fromClass(ValidationXmlParser.class);
            loader = isSecured ? AccessController.doPrivileged(action) : action.run();
            inputStream = loader.getResourceAsStream(path);
        }
        return inputStream;
    }

    private Schema getValidationConfigurationSchema() {
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromClass(ValidationXmlParser.class);
        ClassLoader loader = isSecured ? AccessController.doPrivileged(action) : action.run();
        URL schemaUrl = loader.getResource(VALIDATION_CONFIGURATION_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to create schema for {}: {}", (Object)VALIDATION_CONFIGURATION_XSD, (Object)e.getMessage());
        }
        return schema;
    }
}

