/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validation.metadata.AnnotationIgnores;
import org.hibernate.validation.metadata.ConstraintDescriptorImpl;
import org.hibernate.validation.metadata.ConstraintHelper;
import org.hibernate.validation.metadata.MetaConstraint;
import org.hibernate.validation.util.ContainsField;
import org.hibernate.validation.util.ContainsMethod;
import org.hibernate.validation.util.GetClassLoader;
import org.hibernate.validation.util.GetDeclaredField;
import org.hibernate.validation.util.GetMethod;
import org.hibernate.validation.util.GetMethodFromPropertyName;
import org.hibernate.validation.util.LoadClass;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validation.util.annotationfactory.AnnotationFactory;
import org.hibernate.validation.xml.AnnotationType;
import org.hibernate.validation.xml.BeanType;
import org.hibernate.validation.xml.ClassType;
import org.hibernate.validation.xml.ConstraintDefinitionType;
import org.hibernate.validation.xml.ConstraintMappingsType;
import org.hibernate.validation.xml.ConstraintType;
import org.hibernate.validation.xml.ElementType;
import org.hibernate.validation.xml.FieldType;
import org.hibernate.validation.xml.GetterType;
import org.hibernate.validation.xml.GroupSequenceType;
import org.hibernate.validation.xml.GroupsType;
import org.hibernate.validation.xml.ValidatedByType;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMappingParser {
    private static final Logger log = LoggerFactory.make();
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PACKAGE_SEPERATOR = ".";
    private final Set<Class<?>> processedClasses = new HashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationIgnores annotationIgnores;
    private final Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> constraintMap;
    private final Map<Class<?>, List<Member>> cascadedMembers;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;

    public XmlMappingParser(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.annotationIgnores = new AnnotationIgnores();
        this.constraintMap = new HashMap();
        this.cascadedMembers = new HashMap();
        this.defaultSequences = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Set<InputStream> mappingStreams) {
        for (InputStream in : mappingStreams) {
            try {
                ConstraintMappingsType mapping = this.getValidationConfig(in);
                this.parseConstraintDefinitions(mapping.getConstraintDefinition());
                String defaultPackage = mapping.getDefaultPackage();
                for (BeanType bean : mapping.getBean()) {
                    Class<?> beanClass = this.getClass(bean.getClazz(), defaultPackage);
                    this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
                    this.annotationIgnores.setDefaultIgnoreAnnotation(beanClass, bean.isIgnoreAnnotations());
                    this.parseClassLevelOverrides(bean.getClassType(), beanClass, defaultPackage);
                    this.parseFieldLevelOverrides(bean.getField(), beanClass, defaultPackage);
                    this.parsePropertyLevelOverrides(bean.getGetter(), beanClass, defaultPackage);
                    this.processedClasses.add(beanClass);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn("Error closing input stream: {}", (Object)e.getMessage());
                }
            }
        }
    }

    public Set<Class<?>> getProcessedClasses() {
        return this.processedClasses;
    }

    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    public <T> List<MetaConstraint<T, ? extends Annotation>> getConstraintsForClass(Class<T> beanClass) {
        ArrayList<MetaConstraint<T, Annotation>> list = new ArrayList<MetaConstraint<T, Annotation>>();
        if (this.constraintMap.containsKey(beanClass)) {
            Iterator<MetaConstraint<?, Annotation>> i$ = this.constraintMap.get(beanClass).iterator();
            while (i$.hasNext()) {
                MetaConstraint<?, Annotation> metaConstraint;
                MetaConstraint<?, Annotation> boundMetaConstraint = metaConstraint = i$.next();
                list.add(boundMetaConstraint);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<Member> getCascadedMembersForClass(Class<?> beanClass) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            return this.cascadedMembers.get(beanClass);
        }
        return Collections.emptyList();
    }

    public List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        if (this.defaultSequences.containsKey(beanClass)) {
            return this.defaultSequences.get(beanClass);
        }
        return Collections.emptyList();
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> annotationClass = this.loadClass(annotationClassName, this.getClass());
            if (!annotationClass.isAnnotation()) {
                throw new ValidationException(annotationClassName + " is not an annotation");
            }
            ValidatedByType validatedByType = constraintDefinition.getValidatedBy();
            ArrayList constraintValidatorClasses = new ArrayList();
            if (validatedByType.isIncludeExistingValidators() != null && validatedByType.isIncludeExistingValidators().booleanValue()) {
                constraintValidatorClasses.addAll(this.findConstraintValidatorClasses(annotationClass));
            }
            for (JAXBElement<String> validatorClassName : validatedByType.getValue()) {
                Class<?> validatorClass = this.loadClass((String)validatorClassName.getValue(), this.getClass());
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                    throw new ValidationException(validatorClass + " is not a constraint validator class");
                }
                constraintValidatorClasses.add(validatorClass);
            }
            this.constraintHelper.addConstraintValidatorDefinition(annotationClass, constraintValidatorClasses);
        }
    }

    private Class<?> loadClass(String className, Class<?> caller) {
        LoadClass action = LoadClass.action(className, caller);
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    private List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> findConstraintValidatorClasses(Class<? extends Annotation> annotationType) {
        ArrayList constraintValidatorDefinitonClasses = new ArrayList();
        if (this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraintValidatorDefinitonClasses.addAll(this.constraintHelper.getBuiltInConstraints(annotationType));
        } else {
            Class[] validatedBy;
            Class[] arr$ = validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class validator;
                Class safeValidator = validator = arr$[i$];
                constraintValidatorDefinitonClasses.add(safeValidator);
            }
        }
        return constraintValidatorDefinitonClasses;
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw new ValidationException(beanClass.getName() + " has already be configured in xml.");
        }
    }

    private void parseFieldLevelOverrides(List<FieldType> fields, Class<?> beanClass, String defaultPackage) {
        for (FieldType fieldType : fields) {
            boolean ignoreFieldAnnotation;
            String fieldName = fieldType.getName();
            ContainsField containsAction = ContainsField.action(beanClass, fieldName);
            boolean containsField = System.getSecurityManager() != null ? AccessController.doPrivileged(containsAction).booleanValue() : containsAction.run().booleanValue();
            if (!containsField) {
                throw new ValidationException(beanClass.getName() + " does not contain the fieldType  " + fieldName);
            }
            GetDeclaredField action = GetDeclaredField.action(beanClass, fieldName);
            Field field = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
            boolean bl = ignoreFieldAnnotation = fieldType.isIgnoreAnnotations() == null ? false : fieldType.isIgnoreAnnotations();
            if (ignoreFieldAnnotation) {
                this.annotationIgnores.setIgnoreAnnotationsOnMember(field);
            }
            if (fieldType.getValid() != null) {
                this.addCascadedMember(beanClass, field);
            }
            for (ConstraintType constraint : fieldType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, field, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parsePropertyLevelOverrides(List<GetterType> getters, Class<?> beanClass, String defaultPackage) {
        for (GetterType getterType : getters) {
            boolean ignoreGetterAnnotation;
            String getterName = getterType.getName();
            ContainsMethod cmAction = ContainsMethod.action(beanClass, getterName);
            boolean containsMethod = System.getSecurityManager() != null ? AccessController.doPrivileged(cmAction).booleanValue() : cmAction.run().booleanValue();
            if (!containsMethod) {
                throw new ValidationException(beanClass.getName() + " does not contain the property  " + getterName);
            }
            GetMethodFromPropertyName action = GetMethodFromPropertyName.action(beanClass, getterName);
            Method method = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
            boolean bl = ignoreGetterAnnotation = getterType.isIgnoreAnnotations() == null ? false : getterType.isIgnoreAnnotations();
            if (ignoreGetterAnnotation) {
                this.annotationIgnores.setIgnoreAnnotationsOnMember(method);
            }
            if (getterType.getValid() != null) {
                this.addCascadedMember(beanClass, method);
            }
            for (ConstraintType constraint : getterType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, method, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parseClassLevelOverrides(ClassType classType, Class<?> beanClass, String defaultPackage) {
        List<Class<?>> groupSequence;
        boolean ignoreClassAnnotation;
        if (classType == null) {
            return;
        }
        boolean bl = ignoreClassAnnotation = classType.isIgnoreAnnotations() == null ? false : classType.isIgnoreAnnotations();
        if (ignoreClassAnnotation) {
            this.annotationIgnores.setIgnoreAnnotationsOnClass(beanClass);
        }
        if (!(groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage)).isEmpty()) {
            this.defaultSequences.put(beanClass, groupSequence);
        }
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, null, defaultPackage);
            this.addMetaConstraint(beanClass, metaConstraint);
        }
    }

    private void addMetaConstraint(Class<?> beanClass, MetaConstraint<?, ?> metaConstraint) {
        if (this.constraintMap.containsKey(beanClass)) {
            this.constraintMap.get(beanClass).add(metaConstraint);
        } else {
            ArrayList constraintList = new ArrayList();
            constraintList.add(metaConstraint);
            this.constraintMap.put(beanClass, constraintList);
        }
    }

    private void addCascadedMember(Class<?> beanClass, Member member) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            this.cascadedMembers.get(beanClass).add(member);
        } else {
            ArrayList<Member> tmpList = new ArrayList<Member>();
            tmpList.add(member);
            this.cascadedMembers.put(beanClass, tmpList);
        }
    }

    private List<Class<?>> createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        ArrayList groupSequence = new ArrayList();
        for (JAXBElement<String> groupName : groupSequenceType.getValue()) {
            Class<?> group = this.getClass((String)groupName.getValue(), defaultPackage);
            groupSequence.add(group);
        }
        return groupSequence;
    }

    private <A extends Annotation, T> MetaConstraint<?, ?> createMetaConstraint(ConstraintType constraint, Class<T> beanClass, Member member, String defaultPackage) {
        Class<?> annotationClass = this.getClass(constraint.getAnnotation(), defaultPackage);
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, this.getGroups(constraint.getGroups(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            this.checkNameIsValid(name);
            Class<?> returnType = this.getAnnotationParamterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType);
            annotationDescriptor.setValue(name, elementValue);
        }
        Object annotation = AnnotationFactory.create(annotationDescriptor);
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(annotation, this.constraintHelper);
        MetaConstraint metaConstraint = member == null ? new MetaConstraint(beanClass, constraintDescriptor) : new MetaConstraint(member, beanClass, constraintDescriptor);
        return metaConstraint;
    }

    private <A extends Annotation> Class<?> getAnnotationParamterType(Class<A> annotationClass, String name) {
        GetMethod action = GetMethod.action(annotationClass, name);
        Method m = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        if (m == null) {
            throw new ValidationException("Annotation of type " + annotationClass.getName() + " does not contain a paramter " + name + PACKAGE_SEPERATOR);
        }
        return m.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType) {
        this.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw new ValidationException("Attempt to specify an array where single value is expected.");
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Serializable s : elementType.getContent()) {
            values.add(this.getSingleValue(s, returnType.getComponentType()));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private void removeEmptyContentElements(ElementType elementType) {
        ArrayList<Serializable> contentToDelete = new ArrayList<Serializable>();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.createAnnotation(annotationType, annotationClass);
            }
            catch (ClassCastException e) {
                throw new ValidationException("Unexpected paramter value");
            }
        } else {
            throw new ValidationException("Unexpected paramter value");
        }
        return returnValue;
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> paramterType = this.getAnnotationParamterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, paramterType);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private Object convertStringToReturnType(Class<?> returnType, String value) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid byte format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid short format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid int format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid long format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid float format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid double format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw new ValidationException("Invalid char value: " + value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = this.loadClass(value, this.getClass());
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw new ValidationException("Invalid return type: " + returnType + ". Should be a enumeration type.");
            }
        }
        return returnValue;
    }

    private void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw new ValidationException("message and groups are reserved paramter names.");
        }
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList groupList = new ArrayList();
        for (JAXBElement<String> groupClass : groupsType.getValue()) {
            groupList.add(this.getClass((String)groupClass.getValue(), defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<?> getClass(String clazz, String defaultPackage) {
        String fullyQualifiedClass = this.isQualifiedClass(clazz) ? clazz : defaultPackage + PACKAGE_SEPERATOR + clazz;
        return this.loadClass(fullyQualifiedClass, this.getClass());
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.contains(PACKAGE_SEPERATOR);
    }

    private ConstraintMappingsType getValidationConfig(InputStream in) {
        ConstraintMappingsType constraintMappings;
        Schema schema = this.getMappingSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConstraintMappingsType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(in);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ConstraintMappingsType.class);
            constraintMappings = (ConstraintMappingsType)root.getValue();
        }
        catch (JAXBException e) {
            String msg = "Error parsing mapping file.";
            log.error(msg);
            throw new ValidationException(msg, (Throwable)e);
        }
        return constraintMappings;
    }

    private Schema getMappingSchema() {
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromClass(XmlMappingParser.class);
        ClassLoader loader = isSecured ? AccessController.doPrivileged(action) : action.run();
        URL schemaUrl = loader.getResource(VALIDATION_MAPPING_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to create schema for {}: {}", (Object)VALIDATION_MAPPING_XSD, (Object)e.getMessage());
        }
        return schema;
    }
}

