// $Id: ContainsMethod.java 17422 2009-08-26 12:38:04Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.validator.util;

import java.security.PrivilegedAction;

/**
 * @author Emmanuel Bernard
 */
public class ContainsMethod implements PrivilegedAction<Boolean> {
	private final Class<?> clazz;
	private final String property;

	public static ContainsMethod action(Class<?> clazz, String property) {
		return new ContainsMethod( clazz, property );
	}

	private ContainsMethod(Class<?> clazz, String property) {
		this.clazz = clazz;
		this.property = property;
	}

	public Boolean run() {
		return ReflectionHelper.getMethod( clazz, property ) != null;
	}
}