/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import org.hibernate.validator.engine.ValidatorImpl;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.ConstraintHelper;

public class ValidatorContextImpl
implements ValidatorContext {
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private final MessageInterpolator factoryMessageInterpolator;
    private final TraversableResolver factoryTraversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorContextImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator factoryMessageInterpolator, TraversableResolver factoryTraversableResolver, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.factoryMessageInterpolator = factoryMessageInterpolator;
        this.factoryTraversableResolver = factoryTraversableResolver;
        this.constraintHelper = constraintHelper;
        this.beanMetaDataCache = beanMetaDataCache;
        this.messageInterpolator(factoryMessageInterpolator);
        this.traversableResolver(factoryTraversableResolver);
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.factoryMessageInterpolator : messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.factoryTraversableResolver : traversableResolver;
        return this;
    }

    public Validator getValidator() {
        return new ValidatorImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache);
    }
}

