/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.ElementDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDescriptorImpl<T>
extends ElementDescriptorImpl
implements BeanDescriptor {
    private final BeanMetaData<T> metadataBean;

    public BeanDescriptorImpl(BeanMetaData<T> metadataBean) {
        super(metadataBean.getBeanClass());
        this.metadataBean = metadataBean;
    }

    public boolean isBeanConstrained() {
        return this.metadataBean.getMetaConstraintsAsMap().size() > 0;
    }

    public PropertyDescriptor getConstraintsForProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name cannot be null");
        }
        return this.metadataBean.getPropertyDescriptor(propertyName);
    }

    public Set<PropertyDescriptor> getConstrainedProperties() {
        return this.metadataBean.getConstrainedProperties();
    }
}

