/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.resourceloading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.hibernate.validator.engine.resourceloading.DelegatingResourceBundleLocator;
import org.hibernate.validator.engine.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.engine.resourceloading.ResourceBundleLocator;
import org.hibernate.validator.util.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateResourceBundleLocator
extends DelegatingResourceBundleLocator {
    private final List<String> bundleNames;

    public AggregateResourceBundleLocator(List<String> bundleNames) {
        this(bundleNames, null);
    }

    public AggregateResourceBundleLocator(List<String> bundleNames, ResourceBundleLocator delegate) {
        super(delegate);
        if (bundleNames == null) {
            throw new IllegalArgumentException("bundleNames must not be null.");
        }
        ArrayList<String> tmpBundleNames = new ArrayList<String>();
        tmpBundleNames.addAll(bundleNames);
        this.bundleNames = Collections.unmodifiableList(tmpBundleNames);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> sourceBundles = new ArrayList<ResourceBundle>();
        for (String oneBundleName : this.bundleNames) {
            PlatformResourceBundleLocator oneLocator = new PlatformResourceBundleLocator(oneBundleName);
            ResourceBundle oneBundle = oneLocator.getResourceBundle(locale);
            if (oneBundle == null) continue;
            sourceBundles.add(oneBundle);
        }
        ResourceBundle bundleFromDelegate = super.getResourceBundle(locale);
        if (bundleFromDelegate != null) {
            sourceBundles.add(bundleFromDelegate);
        }
        return sourceBundles.isEmpty() ? null : new AggregateBundle(sourceBundles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AggregateBundle
    extends ResourceBundle {
        private Map<String, Object> contents = new HashMap<String, Object>();

        public AggregateBundle(List<ResourceBundle> bundles) {
            if (bundles != null) {
                for (ResourceBundle bundle : bundles) {
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String oneKey = keys.nextElement();
                        if (this.contents.containsKey(oneKey)) continue;
                        this.contents.put(oneKey, bundle.getObject(oneKey));
                    }
                }
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            return new IteratorEnumeration<String>(this.contents.keySet().iterator());
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.contents.get(key);
        }
    }
}

