/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.resourceloading;

import java.security.AccessController;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hibernate.validator.engine.ResourceBundleMessageInterpolator;
import org.hibernate.validator.engine.resourceloading.ResourceBundleLocator;
import org.hibernate.validator.util.GetClassLoader;
import org.hibernate.validator.util.LoggerFactory;
import org.slf4j.Logger;

public class PlatformResourceBundleLocator
implements ResourceBundleLocator {
    private static final Logger log = LoggerFactory.make();
    private String bundleName;

    public PlatformResourceBundleLocator(String bundleName) {
        this.bundleName = bundleName;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader classLoader;
        ResourceBundle rb = null;
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromContext();
        ClassLoader classLoader2 = classLoader = isSecured ? AccessController.doPrivileged(action) : action.run();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by thread local classloader");
        }
        if (rb == null) {
            action = GetClassLoader.fromClass(ResourceBundleMessageInterpolator.class);
            classLoader = isSecured ? AccessController.doPrivileged(action) : action.run();
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by validator classloader");
        }
        if (log.isDebugEnabled()) {
            if (rb != null) {
                log.debug(this.bundleName + " found");
            } else {
                log.debug(this.bundleName + " not found.");
            }
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(this.bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }
}

