/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.engine.ConstraintViolationImpl;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.MessageInterpolatorContext;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.util.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext<T> {
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<PathImpl>> processedPaths;
    private final List<ConstraintViolation<T>> failingConstraintViolations;
    private boolean allowOneValidationPerPath = true;
    private final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;

    public static <T> ValidationContext<T> getContextForValidate(T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        Class<?> rootBeanClass = object.getClass();
        return new ValidationContext(rootBeanClass, object, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    public static <T> ValidationContext<T> getContextForValidateProperty(T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        Class<?> rootBeanClass = rootBean.getClass();
        return new ValidationContext(rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    public static <T> ValidationContext<T> getContextForValidateValue(Class<T> rootBeanClass, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        return new ValidationContext<Object>(rootBeanClass, null, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    private ValidationContext(Class<T> rootBeanClass, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.processedObjects = new HashMap();
        this.processedPaths = new IdentityHashMap<Object, Set<PathImpl>>();
        this.failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public <U, V> ConstraintViolationImpl<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, (MessageInterpolator.Context)new MessageInterpolatorContext(descriptor, localContext.getCurrentBean()));
        return new ConstraintViolationImpl<T>(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), messageAndPath.getPath(), descriptor, localContext.getElementType());
    }

    public <U, V> List<ConstraintViolationImpl<T>> createConstraintViolations(ValueContext<U, V> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        ArrayList<ConstraintViolationImpl<T>> constraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
        for (MessageAndPath messageAndPath : constraintValidatorContext.getMessageAndPathList()) {
            ConstraintViolationImpl<T> violation = this.createConstraintViolation(localContext, messageAndPath, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isAlreadyValidated(Object value, Class<?> group, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group);
        if (alreadyValidated && this.allowOneValidationPerPath) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markProcessed(Object value, Class<?> group, PathImpl path) {
        this.markProcessForCurrentGroup(value, group);
        if (this.allowOneValidationPerPath) {
            this.markProcessedForCurrentPath(value, path);
        }
    }

    private void addConstraintFailure(ConstraintViolation<T> failingConstraintViolation) {
        int i = this.failingConstraintViolations.indexOf(failingConstraintViolation);
        if (i == -1) {
            this.failingConstraintViolations.add(failingConstraintViolation);
        }
    }

    public void addConstraintFailures(List<ConstraintViolation<T>> failingConstraintViolations) {
        for (ConstraintViolation<T> violation : failingConstraintViolations) {
            this.addConstraintFailure(violation);
        }
    }

    public List<ConstraintViolation<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPaths.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!p.isRootPath() && !path.isRootPath() && !p.isSubPathOf(path) && !path.isSubPathOf(p)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(group);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void markProcessedForCurrentPath(Object value, PathImpl path) {
        PathImpl parentPath = path.getPathWithoutLeafNode();
        if (parentPath == null) {
            parentPath = PathImpl.createNewPath(null);
        }
        if (this.processedPaths.containsKey(value)) {
            this.processedPaths.get(value).add(parentPath);
        } else {
            HashSet<PathImpl> set = new HashSet<PathImpl>();
            set.add(parentPath);
            this.processedPaths.put(value, set);
        }
    }

    private void markProcessForCurrentGroup(Object value, Class<?> group) {
        if (this.processedObjects.containsKey(group)) {
            this.processedObjects.get(group).add(value);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(value);
            this.processedObjects.put(group, set);
        }
    }
}

