/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Payload;
import javax.validation.ValidationException;
import org.hibernate.validator.cfg.CascadeDef;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.ConstraintsForType;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstraintDef<A extends Annotation> {
    protected Class<A> constraintType;
    protected final Map<String, Object> parameters;
    protected final Class<?> beanType;
    protected final ElementType elementType;
    protected final String property;
    protected final ConstraintMapping mapping;

    public ConstraintDef(Class<?> beanType, Class<A> constraintType, String property, ElementType elementType, ConstraintMapping mapping) {
        this(beanType, constraintType, property, elementType, new HashMap<String, Object>(), mapping);
    }

    protected ConstraintDef(Class<?> beanType, Class<A> constraintType, String property, ElementType elementType, Map<String, Object> parameters, ConstraintMapping mapping) {
        if (beanType == null) {
            throw new ValidationException("Null is not a valid bean type");
        }
        if (mapping == null) {
            throw new ValidationException("ConstraintMapping cannot be null");
        }
        if (ElementType.FIELD.equals((Object)elementType) || ElementType.METHOD.equals((Object)elementType)) {
            if (property == null || property.length() == 0) {
                throw new ValidationException("A property level constraint cannot have a null or empty property name");
            }
            if (!ReflectionHelper.propertyExists(beanType, property, elementType)) {
                throw new ValidationException("The class " + beanType + " does not have a property '" + property + "' with access " + (Object)((Object)elementType));
            }
        }
        this.beanType = beanType;
        this.constraintType = constraintType;
        this.parameters = parameters;
        this.property = property;
        this.elementType = elementType;
        this.mapping = mapping;
    }

    protected ConstraintDef addParameter(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    public ConstraintDef message(String message) {
        this.addParameter("message", message);
        return this;
    }

    public ConstraintDef groups(Class<?> ... groups) {
        this.addParameter("groups", groups);
        return this;
    }

    public ConstraintDef payload(Class<? extends Payload> ... payload) {
        this.addParameter("payload", payload);
        return this;
    }

    public <A extends Annotation, T extends ConstraintDef<A>> T constraint(Class<T> definition) {
        Constructor<T> constructor = ReflectionHelper.getConstructor(definition, Class.class, String.class, ElementType.class, ConstraintMapping.class);
        ConstraintDef constraintDefinition = (ConstraintDef)ReflectionHelper.newConstructorInstance(constructor, new Object[]{this.beanType, this.property, this.elementType, this.mapping});
        this.mapping.addConstraintConfig(constraintDefinition);
        return (T)constraintDefinition;
    }

    public ConstraintsForType property(String property, ElementType type) {
        return new ConstraintsForType(this.beanType, property, type, this.mapping);
    }

    public ConstraintsForType type(Class<?> type) {
        return new ConstraintsForType(type, this.mapping);
    }

    public ConstraintsForType valid(String property, ElementType type) {
        this.mapping.addCascadeConfig(new CascadeDef(this.beanType, property, type));
        return new ConstraintsForType(this.beanType, this.mapping);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{beanType=").append(this.beanType);
        sb.append(", constraintType=").append(this.constraintType);
        sb.append(", parameters=").append(this.parameters);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", property='").append(this.property).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

