/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.cfg.CascadeDef;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.ConstraintDefAccessor;
import org.hibernate.validator.cfg.ConstraintsForType;
import org.hibernate.validator.group.DefaultGroupSequenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintMapping {
    private final Map<Class<?>, List<ConstraintDef<?, ?>>> constraintConfig = new HashMap();
    private final Map<Class<?>, List<CascadeDef>> cascadeConfig = new HashMap();
    private final Set<Class<?>> configuredClasses = new HashSet();
    private final Map<Class<?>, List<Class<?>>> defaultGroupSequences = new HashMap();
    private final Map<Class<?>, Class<? extends DefaultGroupSequenceProvider<?>>> defaultGroupSequenceProviders = new HashMap();

    public final ConstraintsForType type(Class<?> beanClass) {
        return new ConstraintsForType(beanClass, this);
    }

    public final Map<Class<?>, List<ConstraintDefAccessor<?>>> getConstraintConfig() {
        HashMap newDefinitions = new HashMap();
        for (Map.Entry<Class<?>, List<ConstraintDef<?, ?>>> entry : this.constraintConfig.entrySet()) {
            ArrayList newList = new ArrayList();
            for (ConstraintDef<?, ?> definition : entry.getValue()) {
                newList.add(ConstraintDefAccessor.getInstance(definition));
            }
            newDefinitions.put(entry.getKey(), newList);
        }
        return newDefinitions;
    }

    public final Map<Class<?>, List<CascadeDef>> getCascadeConfig() {
        return this.cascadeConfig;
    }

    public final Collection<Class<?>> getConfiguredClasses() {
        return this.configuredClasses;
    }

    public final List<Class<?>> getDefaultSequence(Class<?> beanType) {
        if (this.defaultGroupSequences.containsKey(beanType)) {
            return this.defaultGroupSequences.get(beanType);
        }
        return Collections.emptyList();
    }

    public final Class<? extends DefaultGroupSequenceProvider<?>> getDefaultGroupSequenceProvider(Class<?> beanType) {
        return this.defaultGroupSequenceProviders.get(beanType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintMapping");
        sb.append("{cascadeConfig=").append(this.cascadeConfig);
        sb.append(", constraintConfig=").append(this.constraintConfig);
        sb.append(", configuredClasses=").append(this.configuredClasses);
        sb.append(", defaultGroupSequences=").append(this.defaultGroupSequences);
        sb.append('}');
        return sb.toString();
    }

    protected final void addCascadeConfig(CascadeDef cascade) {
        Class<?> beanClass = cascade.getBeanType();
        this.configuredClasses.add(beanClass);
        if (this.cascadeConfig.containsKey(beanClass)) {
            this.cascadeConfig.get(beanClass).add(cascade);
        } else {
            ArrayList<CascadeDef> cascadeList = new ArrayList<CascadeDef>();
            cascadeList.add(cascade);
            this.cascadeConfig.put(beanClass, cascadeList);
        }
    }

    protected final void addDefaultGroupSequence(Class<?> beanClass, List<Class<?>> defaultGroupSequence) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequences.put(beanClass, defaultGroupSequence);
    }

    protected final <T extends DefaultGroupSequenceProvider<?>> void addDefaultGroupSequenceProvider(Class<?> beanClass, Class<T> defaultGroupSequenceProviderClass) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequenceProviders.put(beanClass, defaultGroupSequenceProviderClass);
    }

    protected final void addConstraintConfig(ConstraintDef<?, ?> definition) {
        Class<?> beanClass = definition.beanType;
        this.configuredClasses.add(beanClass);
        if (this.constraintConfig.containsKey(beanClass)) {
            this.constraintConfig.get(beanClass).add(definition);
        } else {
            ArrayList definitionList = new ArrayList();
            definitionList.add(definition);
            this.constraintConfig.put(beanClass, definitionList);
        }
    }
}

