/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.util.LRUMap;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree<A extends Annotation> {
    private static final Logger log = LoggerFactory.make();
    private static final int MAX_TYPE_CACHE_SIZE = 20;
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;
    private final Map<Type, Class<? extends ConstraintValidator<?, ?>>> availableValidatorTypes;
    private final Map<ValidatorCacheKey, ConstraintValidator<A, ?>> constraintValidatorCache;
    private final Map<Type, Type> suitableTypeMap;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        this.constraintValidatorCache = new ConcurrentHashMap();
        HashSet<ConstraintDescriptorImpl> composingConstraints = new HashSet<ConstraintDescriptorImpl>();
        for (ConstraintDescriptor<?> composingConstraint : descriptor.getComposingConstraints()) {
            composingConstraints.add((ConstraintDescriptorImpl)composingConstraint);
        }
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl composingDescriptor : composingConstraints) {
            ConstraintTree treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
        this.availableValidatorTypes = ValidatorTypeHelper.getValidatorsTypes(descriptor.getConstraintValidatorClasses());
        this.suitableTypeMap = Collections.synchronizedMap(new LRUMap(20));
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public final List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public final <T, U, V, E extends ConstraintViolation<T>> boolean validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext) {
        HashSet constraintViolations = new HashSet();
        this.validateConstraints(executionContext, valueContext, constraintViolations);
        if (!constraintViolations.isEmpty()) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = this.validateComposingConstraints(executionContext, valueContext, constraintViolations);
        HashSet<E> localViolationList = new HashSet<E>();
        if (!this.descriptor.getConstraintValidatorClasses().isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Validating value {} against constraint defined by {}", valueContext.getCurrentValidatedValue(), this.descriptor);
            }
            ConstraintValidator<A, V> validator = this.getInitializedValidator(valueContext.getTypeOfAnnotatedElement(), executionContext.getConstraintValidatorFactory());
            ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(valueContext.getPropertyPath(), this.descriptor);
            localViolationList.addAll(this.validateSingleConstraint(executionContext, valueContext, constraintValidatorContext, validator));
            if (localViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
            } else {
                compositionResult.setAllTrue(false);
            }
        }
        if (!this.passesCompositionTypeRequirement(constraintViolations, compositionResult)) {
            this.prepareFinalConstraintViolations(executionContext, valueContext, constraintViolations, localViolationList);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void prepareFinalConstraintViolations(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations, Set<E> localViolationList) {
        if (this.reportAsSingleViolation()) {
            constraintViolations.clear();
            if (localViolationList.isEmpty()) {
                String message = (String)this.getDescriptor().getAttributes().get("message");
                MessageAndPath messageAndPath = new MessageAndPath(message, valueContext.getPropertyPath());
                E violation = executionContext.createConstraintViolation(valueContext, messageAndPath, this.descriptor);
                constraintViolations.add(violation);
            }
        }
        constraintViolations.addAll(localViolationList);
    }

    private <T, U, V, E extends ConstraintViolation<T>> CompositionResult validateComposingConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = new CompositionResult(true, false);
        for (ConstraintTree<?> tree : this.getChildren()) {
            HashSet tmpViolationList = new HashSet();
            super.validateConstraints(executionContext, valueContext, tmpViolationList);
            constraintViolations.addAll(tmpViolationList);
            if (tmpViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
                if (this.descriptor.getCompositionType() != CompositionType.OR) continue;
                break;
            }
            compositionResult.setAllTrue(false);
        }
        return compositionResult;
    }

    private boolean passesCompositionTypeRequirement(Set<?> constraintViolations, CompositionResult compositionResult) {
        CompositionType compositionType = this.getDescriptor().getCompositionType();
        boolean passedValidation = false;
        switch (compositionType) {
            case OR: {
                passedValidation = compositionResult.isAtLeastOneTrue();
                break;
            }
            case AND: {
                passedValidation = compositionResult.isAllTrue();
                break;
            }
            case ALL_FALSE: {
                boolean bl = passedValidation = !compositionResult.isAtLeastOneTrue();
            }
        }
        assert (!passedValidation || compositionType != CompositionType.AND || constraintViolations.isEmpty());
        if (passedValidation) {
            constraintViolations.clear();
        }
        return passedValidation;
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateSingleConstraint(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator) {
        boolean isValid;
        HashSet<E> cv = new HashSet<E>();
        try {
            isValid = validator.isValid(valueContext.getCurrentValidatedValue(), (ConstraintValidatorContext)constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unexpected exception during isValid call", (Throwable)e);
        }
        if (!isValid) {
            cv.addAll(executionContext.createConstraintViolations(valueContext, constraintValidatorContext));
        }
        return cv;
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation() || this.getDescriptor().getCompositionType() == CompositionType.ALL_FALSE;
    }

    private <V> ConstraintValidator<A, V> getInitializedValidator(Type validatedValueType, ConstraintValidatorFactory constraintFactory) {
        Object constraintValidator;
        Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(validatedValueType);
        if (!(constraintFactory instanceof ConstraintValidatorFactoryImpl)) {
            return this.createAndInitializeValidator(constraintFactory, validatorClass);
        }
        ValidatorCacheKey key = new ValidatorCacheKey(constraintFactory, validatorClass);
        if (!this.constraintValidatorCache.containsKey(key)) {
            constraintValidator = this.createAndInitializeValidator(constraintFactory, validatorClass);
            this.constraintValidatorCache.put(key, (ConstraintValidator<A, ?>)constraintValidator);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Constraint validator {} found in cache");
            }
            constraintValidator = this.constraintValidatorCache.get(key);
        }
        return constraintValidator;
    }

    private <V> ConstraintValidator<A, V> createAndInitializeValidator(ConstraintValidatorFactory constraintFactory, Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        ConstraintValidator constraintValidator = constraintFactory.getInstance(validatorClass);
        if (constraintValidator == null) {
            throw new ValidationException("Constraint factory returned null when trying to create instance of " + validatorClass.getName());
        }
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Type validatedValueType) {
        if (this.suitableTypeMap.containsKey(validatedValueType)) {
            return this.availableValidatorTypes.get(this.suitableTypeMap.get(validatedValueType));
        }
        List<Type> discoveredSuitableTypes = this.findSuitableValidatorTypes(validatedValueType);
        this.resolveAssignableTypes(discoveredSuitableTypes);
        this.verifyResolveWasUnique(validatedValueType, discoveredSuitableTypes);
        Type suitableType = discoveredSuitableTypes.get(0);
        this.suitableTypeMap.put(validatedValueType, suitableType);
        return this.availableValidatorTypes.get(suitableType);
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            String className = valueClass.toString();
            if (valueClass instanceof Class) {
                Class clazz = (Class)valueClass;
                className = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
            }
            throw new UnexpectedTypeException("No validator could be found for type: " + className);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validator classes which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new UnexpectedTypeException(builder.toString());
        }
    }

    private List<Type> findSuitableValidatorTypes(Type type) {
        ArrayList<Type> determinedSuitableTypes = new ArrayList<Type>();
        for (Type validatorType : this.availableValidatorTypes.keySet()) {
            if (!TypeUtils.isAssignable(validatorType, type) || determinedSuitableTypes.contains(validatorType)) continue;
            determinedSuitableTypes.add(validatorType);
        }
        return determinedSuitableTypes;
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeUtils.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeUtils.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private <V> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, V> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to initialize " + constraintValidator.getClass().getName(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append(", constraintValidatorCache=").append(this.constraintValidatorCache);
        sb.append('}');
        return sb.toString();
    }

    private static final class CompositionResult {
        private boolean allTrue;
        private boolean atLeastOneTrue;

        CompositionResult(boolean allTrue, boolean atLeastOneTrue) {
            this.allTrue = allTrue;
            this.atLeastOneTrue = atLeastOneTrue;
        }

        public boolean isAllTrue() {
            return this.allTrue;
        }

        public boolean isAtLeastOneTrue() {
            return this.atLeastOneTrue;
        }

        public void setAllTrue(boolean allTrue) {
            this.allTrue = allTrue;
        }

        public void setAtLeastOneTrue(boolean atLeastOneTrue) {
            this.atLeastOneTrue = atLeastOneTrue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValidatorCacheKey {
        private ConstraintValidatorFactory constraintValidatorFactory;
        private Class<? extends ConstraintValidator<?, ?>> validatorType;

        private ValidatorCacheKey(ConstraintValidatorFactory constraintValidatorFactory, Class<? extends ConstraintValidator<?, ?>> validatorType) {
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.validatorType = validatorType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidatorCacheKey that = (ValidatorCacheKey)o;
            if (this.constraintValidatorFactory != null ? !this.constraintValidatorFactory.equals(that.constraintValidatorFactory) : that.constraintValidatorFactory != null) {
                return false;
            }
            return !(this.validatorType != null ? !this.validatorType.equals(that.validatorType) : that.validatorType != null);
        }

        public int hashCode() {
            int result = this.constraintValidatorFactory != null ? this.constraintValidatorFactory.hashCode() : 0;
            result = 31 * result + (this.validatorType != null ? this.validatorType.hashCode() : 0);
            return result;
        }
    }
}

