/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.metadata.AggregatedMethodMetaData;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.ElementDescriptorImpl;
import org.hibernate.validator.metadata.ParameterDescriptorImpl;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.method.metadata.MethodDescriptor;
import org.hibernate.validator.method.metadata.ParameterDescriptor;
import org.hibernate.validator.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptorImpl
extends ElementDescriptorImpl
implements MethodDescriptor {
    private final AggregatedMethodMetaData methodMetaData;

    public MethodDescriptorImpl(BeanMetaData<?> metaDataBean, AggregatedMethodMetaData methodMetaData) {
        super(methodMetaData.getMethod().getReturnType(), metaDataBean);
        this.methodMetaData = methodMetaData;
        for (BeanMetaConstraint<?, Annotation> oneConstraint : methodMetaData) {
            this.addConstraintDescriptor(oneConstraint.getDescriptor());
        }
    }

    @Override
    public String getMethodName() {
        return this.methodMetaData.getMethod().getName();
    }

    @Override
    public List<ParameterDescriptor> getParameterConstraints() {
        ArrayList<ParameterDescriptor> theValue = CollectionHelper.newArrayList();
        for (ParameterMetaData oneParameter : this.methodMetaData.getAllParameterMetaData()) {
            theValue.add(new ParameterDescriptorImpl(this.getMetaDataBean(), oneParameter));
        }
        return theValue;
    }

    @Override
    public boolean isCascaded() {
        return this.methodMetaData.isCascading();
    }
}

