/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata.location;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.hibernate.validator.metadata.location.ConstraintLocation;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConstraintLocation
implements ConstraintLocation {
    private final Member member;
    private final String propertyName;
    private final Class<?> beanClass;

    public BeanConstraintLocation(Class<?> beanClass, Member member) {
        this.member = member;
        this.propertyName = this.member != null ? ReflectionHelper.getPropertyName(member) : null;
        this.beanClass = beanClass;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Member getMember() {
        return this.member;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t;
        if (this.member == null) {
            t = this.beanClass;
        } else {
            t = ReflectionHelper.typeOf(this.member);
            if (t instanceof Class && ((Class)t).isPrimitive()) {
                t = ReflectionHelper.boxedType(t);
            }
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanConstraintLocation");
        sb.append("{beanClass=").append(this.beanClass);
        sb.append(", member=").append(this.member);
        sb.append(", propertyName='").append(this.propertyName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

