/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.MethodParameterNodeImpl;
import org.hibernate.validator.internal.engine.MethodReturnValueNodeImpl;
import org.hibernate.validator.internal.engine.NodeImpl;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = 7564511574909882392L;
    private static final Log log = LoggerFactory.make();
    public static final String PROPERTY_PATH_SEPARATOR = ".";
    private static final String LEADING_PROPERTY_GROUP = "[^\\[\\.]+";
    private static final String OPTIONAL_INDEX_GROUP = "\\[(\\w*)\\]";
    private static final String REMAINING_PROPERTY_STRING = "\\.(.*)";
    private static final Pattern PATH_PATTERN = Pattern.compile("([^\\[\\.]+)(\\[(\\w*)\\])?(\\.(.*))*");
    private static final int PROPERTY_NAME_GROUP = 1;
    private static final int INDEXED_GROUP = 2;
    private static final int INDEX_GROUP = 3;
    private static final int REMAINING_STRING_GROUP = 5;
    private final List<Path.Node> nodeList = new ArrayList<Path.Node>();
    private NodeImpl currentLeafNode;
    private int hashCode;

    public static PathImpl createPathFromString(String propertyPath) {
        Contracts.assertNotNull(propertyPath, Messages.MESSAGES.propertyPathCannotBeNull());
        if (propertyPath.length() == 0) {
            return PathImpl.createNewPath(null);
        }
        return PathImpl.parseProperty(propertyPath);
    }

    public static PathImpl createPathForMethodParameter(Method method, String parameterName) {
        Contracts.assertNotNull(method, "A method is required to create a method parameter path.");
        Contracts.assertNotNull(parameterName, "A parameter name is required to create a method parameter path.");
        PathImpl path = PathImpl.createRootPath();
        path.addMethodParameterNode(method, parameterName);
        return path;
    }

    public static PathImpl createPathForMethodReturnValue(Method method) {
        Contracts.assertNotNull(method, "A method is required to create a method return value path.");
        PathImpl path = PathImpl.createRootPath();
        path.addMethodReturnValueNode(method);
        return path;
    }

    public static PathImpl createNewPath(String name) {
        PathImpl path = new PathImpl();
        path.addNode(name);
        return path;
    }

    public static PathImpl createRootPath() {
        return PathImpl.createNewPath(null);
    }

    public static PathImpl createCopy(PathImpl path) {
        return new PathImpl(path);
    }

    public final boolean isRootPath() {
        return this.nodeList.size() == 1 && this.nodeList.get(0).getName() == null;
    }

    public final PathImpl getPathWithoutLeafNode() {
        return new PathImpl(this.nodeList.subList(0, this.nodeList.size() - 1));
    }

    public final NodeImpl addNode(String nodeName) {
        NodeImpl parent = this.nodeList.size() == 0 ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        this.currentLeafNode = new NodeImpl(nodeName, parent, false, null, null);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    private NodeImpl addMethodParameterNode(Method method, String parameterName) {
        NodeImpl parent = this.nodeList.size() == 0 ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        this.currentLeafNode = new MethodParameterNodeImpl(method, parameterName, parent);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    private NodeImpl addMethodReturnValueNode(Method method) {
        NodeImpl parent = this.nodeList.size() == 0 ? null : (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
        this.currentLeafNode = new MethodReturnValueNodeImpl(method, parent);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl makeLeafNodeIterable() {
        NodeImpl leafNode = this.getLeafNode();
        this.currentLeafNode = new NodeImpl(leafNode.getName(), leafNode.getParent(), true, null, null);
        this.nodeList.remove(leafNode);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl setLeafNodeIndex(Integer index) {
        NodeImpl leafNode = this.getLeafNode();
        this.currentLeafNode = new NodeImpl(leafNode.getName(), leafNode.getParent(), true, index, null);
        this.nodeList.remove(leafNode);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl setLeafNodeMapKey(Object key) {
        NodeImpl leafNode = this.getLeafNode();
        this.currentLeafNode = new NodeImpl(leafNode.getName(), leafNode.getParent(), true, null, key);
        this.nodeList.remove(leafNode);
        this.nodeList.add(this.currentLeafNode);
        this.hashCode = -1;
        return this.currentLeafNode;
    }

    public final NodeImpl getLeafNode() {
        return this.currentLeafNode;
    }

    public final Iterator<Path.Node> iterator() {
        if (this.nodeList.size() == 0) {
            return Collections.emptyList().iterator();
        }
        if (this.nodeList.size() == 1) {
            return this.nodeList.iterator();
        }
        return this.nodeList.subList(1, this.nodeList.size()).iterator();
    }

    public final String asString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (int i = 1; i < this.nodeList.size(); ++i) {
            NodeImpl nodeImpl = (NodeImpl)this.nodeList.get(i);
            if (nodeImpl.getName() != null) {
                if (!first) {
                    builder.append(PROPERTY_PATH_SEPARATOR);
                }
                builder.append(nodeImpl.asString());
            }
            first = false;
        }
        return builder.toString();
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathImpl path = (PathImpl)o;
        if (this.nodeList != null && !((Object)this.nodeList).equals(path.nodeList)) {
            return false;
        }
        return this.nodeList != null || path.nodeList == null;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.buildHashCode();
        }
        return this.hashCode;
    }

    public void buildHashCode() {
        this.hashCode = this.nodeList != null ? ((Object)this.nodeList).hashCode() : 0;
    }

    private PathImpl(PathImpl path) {
        NodeImpl parent = null;
        NodeImpl node = null;
        for (int i = 0; i < path.nodeList.size(); ++i) {
            node = (NodeImpl)path.nodeList.get(i);
            NodeImpl newNode = new NodeImpl(node, parent);
            this.nodeList.add(newNode);
            parent = newNode;
        }
        this.currentLeafNode = node;
    }

    private PathImpl() {
    }

    private PathImpl(List<Path.Node> nodeList) {
        for (Path.Node node : nodeList) {
            this.nodeList.add(node);
        }
    }

    private static PathImpl parseProperty(String property) {
        PathImpl path = PathImpl.createNewPath(null);
        String tmp = property;
        do {
            Matcher matcher;
            if ((matcher = PATH_PATTERN.matcher(tmp)).matches()) {
                String indexOrKey;
                String value = matcher.group(1);
                if (!PathImpl.isValidJavaIdentifier(value)) {
                    throw log.getInvalidJavaIdentifierException(value);
                }
                path.addNode(value);
                if (matcher.group(2) != null) {
                    path.makeLeafNodeIterable();
                }
                if ((indexOrKey = matcher.group(3)) != null && indexOrKey.length() > 0) {
                    try {
                        Integer i = Integer.parseInt(indexOrKey);
                        path.setLeafNodeIndex(i);
                    }
                    catch (NumberFormatException e) {
                        path.setLeafNodeMapKey(indexOrKey);
                    }
                }
            } else {
                throw log.getUnableToParsePropertyPathException(property);
            }
            tmp = matcher.group(5);
        } while (tmp != null);
        if (path.getLeafNode().isIterable()) {
            path.addNode(null);
        }
        return path;
    }

    private static boolean isValidJavaIdentifier(String identifier) {
        Contracts.assertNotNull(identifier, "identifier param cannot be null");
        if (identifier.length() == 0 || !Character.isJavaIdentifierStart((int)identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart((int)identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

