/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.engine.ConfigurationImpl;
import org.hibernate.validator.internal.engine.ValidatorContextImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.ProgrammaticMappingMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.XmlConfigurationMetaDataProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private static final Log log = LoggerFactory.make();
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final BeanMetaDataManager metaDataManager;
    private final boolean failFast;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        ConstraintHelper constraintHelper = new ConstraintHelper();
        boolean tmpFailFast = false;
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (!configurationState.getMappingStreams().isEmpty()) {
            metaDataProviders.add(new XmlConfigurationMetaDataProvider(constraintHelper, configurationState.getMappingStreams()));
        }
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getProgrammaticMappings().size() > 0) {
                metaDataProviders.add(new ProgrammaticMappingMetaDataProvider(constraintHelper, hibernateSpecificConfig.getProgrammaticMappings()));
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
        }
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(configurationState, tmpFailFast);
        this.metaDataManager = new BeanMetaDataManager(constraintHelper, metaDataProviders);
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        if (HibernateValidatorFactory.class.equals(type)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedException(type);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.metaDataManager, this.failFast);
    }

    private boolean checkPropertiesForFailFast(ConfigurationState configurationState, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = (String)configurationState.getProperties().get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw log.getInconsistentFailFastConfigurationException();
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }
}

