/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataCache {
    private final ConcurrentMap<Class<?>, BeanMetaData<?>> metadataProviders = new ConcurrentHashMap(10);

    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        Contracts.assertNotNull(beanClass, Messages.MESSAGES.mustNotBeNull("Class"));
        return (BeanMetaDataImpl)this.metadataProviders.get(beanClass);
    }

    public <T> BeanMetaData<T> addBeanMetaData(Class<T> beanClass, BeanMetaData<T> metaData) {
        Contracts.assertNotNull(beanClass, Messages.MESSAGES.mustNotBeNull("Class"));
        Contracts.assertNotNull(metaData, Messages.MESSAGES.mustNotBeNull("MetaData"));
        return this.metadataProviders.putIfAbsent(beanClass, metaData);
    }
}

