/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.BeanMetaDataCache;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import org.hibernate.validator.internal.metadata.core.AnnotationIgnores;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataManager {
    private final MetaDataProvider defaultProvider;
    private final List<MetaDataProvider> nonAnnotationMetaDataProviders;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;
    private AnnotationIgnores annotationIgnores;
    private final Map<Class<?>, Set<BeanConfiguration<?>>> configurationsByClass;

    public BeanMetaDataManager(ConstraintHelper constraintHelper, MetaDataProvider ... metaDataProviders) {
        this(constraintHelper, Arrays.asList(metaDataProviders));
    }

    public BeanMetaDataManager(ConstraintHelper constraintHelper, List<MetaDataProvider> metaDataProviders) {
        this.constraintHelper = constraintHelper;
        this.nonAnnotationMetaDataProviders = metaDataProviders;
        this.configurationsByClass = CollectionHelper.newHashMap();
        this.beanMetaDataCache = new BeanMetaDataCache();
        this.loadConfigurationsNonDefaultProviders();
        this.defaultProvider = new AnnotationMetaDataProvider(constraintHelper, this.annotationIgnores);
    }

    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataCache.getBeanMetaData(beanClass);
        if (beanMetaData == null) {
            this.addAll(this.defaultProvider.getBeanConfigurationForHierarchy(beanClass));
            beanMetaData = this.createBeanMetaData(beanClass);
            BeanMetaData<T> cachedBeanMetaData = this.beanMetaDataCache.addBeanMetaData(beanClass, beanMetaData);
            if (cachedBeanMetaData != null) {
                beanMetaData = cachedBeanMetaData;
            }
        }
        return beanMetaData;
    }

    private <T> BeanMetaDataImpl<T> createBeanMetaData(Class<T> clazz) {
        BeanMetaDataImpl.BeanMetaDataBuilder<T> builder = BeanMetaDataImpl.BeanMetaDataBuilder.getInstance(this.constraintHelper, clazz);
        for (Class<?> oneHierarchyClass : ReflectionHelper.computeClassHierarchy(clazz, true)) {
            for (BeanConfiguration<?> oneConfiguration : this.configurationsByClass.get(oneHierarchyClass)) {
                builder.add(oneConfiguration);
            }
        }
        return builder.build();
    }

    private void loadConfigurationsNonDefaultProviders() {
        for (MetaDataProvider metaDataProvider : this.nonAnnotationMetaDataProviders) {
            if (metaDataProvider.getAnnotationIgnores() != null) {
                this.annotationIgnores = metaDataProvider.getAnnotationIgnores();
            }
            this.addAll(metaDataProvider.getAllBeanConfigurations());
        }
        if (this.annotationIgnores == null) {
            this.annotationIgnores = new AnnotationIgnores();
        }
    }

    private void addAll(Set<BeanConfiguration<?>> configurations) {
        for (BeanConfiguration<?> beanConfiguration : configurations) {
            Set<BeanConfiguration<?>> configurationsForType = this.configurationsByClass.get(beanConfiguration.getBeanClass());
            if (configurationsForType == null) {
                configurationsForType = CollectionHelper.newHashSet();
                this.configurationsByClass.put(beanConfiguration.getBeanClass(), configurationsForType);
            }
            configurationsForType.add(beanConfiguration);
        }
    }
}

