/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.group.DefaultGroupSequenceProvider;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.MethodMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.BeanDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.method.metadata.MethodDescriptor;
import org.hibernate.validator.method.metadata.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Log log = LoggerFactory.make();
    private final Class<T> beanClass;
    private final Set<MetaConstraint<?>> allMetaConstraints;
    private final Set<MetaConstraint<?>> directMetaConstraints;
    private final Map<String, MethodMetaData> methodMetaData;
    private final Map<String, PropertyMetaData> propertyMetaData;
    private final Set<Member> cascadedMembers;
    private List<Class<?>> defaultGroupSequence = CollectionHelper.newArrayList();
    private DefaultGroupSequenceProvider<T> defaultGroupSequenceProvider;
    private List<Class<?>> classHierarchyWithoutInterfaces;

    public BeanMetaDataImpl(Class<T> beanClass, List<Class<?>> defaultGroupSequence, Class<? extends DefaultGroupSequenceProvider<?>> defaultGroupSequenceProvider, Set<ConstraintMetaData> constraintMetaData) {
        this.beanClass = beanClass;
        this.propertyMetaData = CollectionHelper.newHashMap();
        HashSet<PropertyMetaData> propertyMetaDataSet = CollectionHelper.newHashSet();
        HashSet<MethodMetaData> methodMetaDataSet = CollectionHelper.newHashSet();
        for (ConstraintMetaData oneElement : constraintMetaData) {
            if (oneElement.getKind() == ConstraintMetaData.ConstraintMetaDataKind.PROPERTY) {
                propertyMetaDataSet.add((PropertyMetaData)oneElement);
                continue;
            }
            methodMetaDataSet.add((MethodMetaData)oneElement);
        }
        HashSet cascadedMembers = CollectionHelper.newHashSet();
        HashSet allMetaConstraints = CollectionHelper.newHashSet();
        for (PropertyMetaData oneProperty : propertyMetaDataSet) {
            this.propertyMetaData.put(oneProperty.getName(), oneProperty);
            if (oneProperty.isCascading()) {
                cascadedMembers.addAll(oneProperty.getCascadingMembers());
            }
            allMetaConstraints.addAll(oneProperty.getConstraints());
        }
        this.cascadedMembers = Collections.unmodifiableSet(cascadedMembers);
        this.allMetaConstraints = Collections.unmodifiableSet(allMetaConstraints);
        this.classHierarchyWithoutInterfaces = ReflectionHelper.computeClassHierarchy(beanClass, false);
        this.setDefaultGroupSequenceOrProvider(defaultGroupSequence, defaultGroupSequenceProvider);
        this.directMetaConstraints = this.buildDirectConstraintSets();
        this.methodMetaData = Collections.unmodifiableMap(this.buildMethodMetaData(methodMetaDataSet));
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.getBeanDescriptorInternal();
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.getBeanDescriptorInternal();
    }

    @Override
    public Set<Member> getCascadedMembers() {
        return this.cascadedMembers;
    }

    @Override
    public Set<MetaConstraint<?>> getMetaConstraints() {
        return this.allMetaConstraints;
    }

    @Override
    public Set<MetaConstraint<?>> getDirectMetaConstraints() {
        return this.directMetaConstraints;
    }

    @Override
    public MethodMetaData getMetaDataFor(Method method) {
        return this.methodMetaData.get(method.getName() + Arrays.toString(method.getParameterTypes()));
    }

    @Override
    public Set<MethodMetaData> getAllMethodMetaData() {
        return new HashSet<MethodMetaData>(this.methodMetaData.values());
    }

    @Override
    public PropertyMetaData getMetaDataFor(String propertyName) {
        return this.propertyMetaData.get(propertyName);
    }

    @Override
    public boolean isPropertyPresent(String name) {
        return this.propertyMetaData.containsKey(name);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence(T beanState) {
        if (this.hasDefaultGroupSequenceProvider()) {
            List<Class<?>> providerDefaultGroupSequence = this.defaultGroupSequenceProvider.getValidationGroups(beanState);
            return this.getValidDefaultGroupSequence(providerDefaultGroupSequence);
        }
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1 || this.hasDefaultGroupSequenceProvider();
    }

    @Override
    public Set<PropertyMetaData> getAllPropertyMetaData() {
        return Collections.unmodifiableSet(new HashSet<PropertyMetaData>(this.propertyMetaData.values()));
    }

    @Override
    public List<Class<?>> getClassHierarchy() {
        return this.classHierarchyWithoutInterfaces;
    }

    private BeanDescriptorImpl<T> getBeanDescriptorInternal() {
        return new BeanDescriptorImpl<T>(this.beanClass, this.getClassLevelConstraintsAsDescriptors(), this.getConstrainedPropertiesAsDescriptors(), this.getMethodsAsDescriptors(), this.defaultGroupSequenceIsRedefined(), this.getDefaultGroupSequence(null));
    }

    private Set<ConstraintDescriptorImpl<?>> getClassLevelConstraintsAsDescriptors() {
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(this.allMetaConstraints);
        HashSet<ConstraintDescriptorImpl<?>> theValue = CollectionHelper.newHashSet();
        for (MetaConstraint<?> oneConstraint : classLevelConstraints) {
            theValue.add(oneConstraint.getDescriptor());
        }
        return theValue;
    }

    private Map<String, PropertyDescriptor> getConstrainedPropertiesAsDescriptors() {
        HashMap<String, PropertyDescriptor> theValue = CollectionHelper.newHashMap();
        for (Map.Entry<String, PropertyMetaData> oneProperty : this.propertyMetaData.entrySet()) {
            if (!oneProperty.getValue().isConstrained()) continue;
            theValue.put(oneProperty.getKey(), (PropertyDescriptor)oneProperty.getValue().asDescriptor(this.defaultGroupSequenceIsRedefined(), (List)this.getDefaultGroupSequence(null)));
        }
        return theValue;
    }

    private Map<String, MethodDescriptor> getMethodsAsDescriptors() {
        HashMap<String, MethodDescriptor> theValue = CollectionHelper.newHashMap();
        for (Map.Entry<String, MethodMetaData> oneMethod : this.methodMetaData.entrySet()) {
            theValue.put(oneMethod.getKey(), (MethodDescriptor)oneMethod.getValue().asDescriptor(this.defaultGroupSequenceIsRedefined(), (List)this.getDefaultGroupSequence(null)));
        }
        return theValue;
    }

    private void setDefaultGroupSequenceOrProvider(List<Class<?>> defaultGroupSequence, Class<? extends DefaultGroupSequenceProvider<?>> defaultGroupSequenceProvider) {
        if (defaultGroupSequence != null && defaultGroupSequenceProvider != null) {
            throw log.getInvalidDefaultGroupSequenceDefinitionException();
        }
        if (defaultGroupSequenceProvider != null) {
            this.defaultGroupSequenceProvider = this.newGroupSequenceProviderInstance(defaultGroupSequenceProvider);
        } else if (defaultGroupSequence != null && !defaultGroupSequence.isEmpty()) {
            this.setDefaultGroupSequence(defaultGroupSequence);
        } else {
            this.setDefaultGroupSequence(Arrays.asList(this.beanClass));
        }
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Set<MetaConstraint<?>> constraints) {
        Set<MetaConstraint<?>> classLevelConstraints = CollectionHelper.partition(constraints, this.byElementType()).get((Object)ElementType.TYPE);
        return classLevelConstraints != null ? classLevelConstraints : Collections.emptySet();
    }

    private Set<MetaConstraint<?>> buildDirectConstraintSets() {
        HashSet constraints = CollectionHelper.newHashSet();
        Set<Class<?>> classAndInterfaces = ReflectionHelper.computeAllImplementedInterfaces(this.beanClass);
        classAndInterfaces.add(this.beanClass);
        for (Class<?> clazz : classAndInterfaces) {
            for (MetaConstraint<?> oneConstraint : this.allMetaConstraints) {
                if (!oneConstraint.getLocation().getBeanClass().equals(clazz)) continue;
                constraints.add(oneConstraint);
            }
        }
        return Collections.unmodifiableSet(constraints);
    }

    private Map<String, MethodMetaData> buildMethodMetaData(Set<MethodMetaData> allMethodMetaData) {
        HashMap<String, MethodMetaData> theValue = CollectionHelper.newHashMap();
        for (MethodMetaData oneAggregatedMethodMetaData : allMethodMetaData) {
            theValue.put(oneAggregatedMethodMetaData.getName() + Arrays.toString(oneAggregatedMethodMetaData.getParameterTypes()), oneAggregatedMethodMetaData);
        }
        return theValue;
    }

    private void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = this.getValidDefaultGroupSequence(groupSequence);
    }

    private List<Class<?>> getValidDefaultGroupSequence(List<Class<?>> groupSequence) {
        ArrayList validDefaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        if (groupSequence != null) {
            for (Class<?> group : groupSequence) {
                if (group.getName().equals(this.beanClass.getName())) {
                    validDefaultGroupSequence.add(Default.class);
                    groupSequenceContainsDefault = true;
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw log.getNoDefaultGroupInGroupSequenceException();
                }
                validDefaultGroupSequence.add(group);
            }
        }
        if (!groupSequenceContainsDefault) {
            throw log.getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(this.beanClass.getName());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Members of the default group sequence for bean %s are: %s.", this.beanClass.getName(), validDefaultGroupSequence);
        }
        return validDefaultGroupSequence;
    }

    private boolean hasDefaultGroupSequenceProvider() {
        return this.defaultGroupSequenceProvider != null;
    }

    private <U extends DefaultGroupSequenceProvider<?>> DefaultGroupSequenceProvider<T> newGroupSequenceProviderInstance(Class<U> providerClass) {
        Method[] providerMethods;
        for (Method method : providerMethods = ReflectionHelper.getMethods(providerClass)) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!"getValidationGroups".equals(method.getName()) || method.isBridge() || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(this.beanClass)) continue;
            return (DefaultGroupSequenceProvider)ReflectionHelper.newInstance(providerClass, "the default group sequence provider");
        }
        throw log.getWrongDefaultGroupSequenceProviderTypeException(this.beanClass.getName());
    }

    private CollectionHelper.Partitioner<ElementType, MetaConstraint<?>> byElementType() {
        return new CollectionHelper.Partitioner<ElementType, MetaConstraint<?>>(){

            @Override
            public ElementType getPartition(MetaConstraint<?> constraint) {
                return constraint.getElementType();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass.getSimpleName());
        sb.append(", constraintCount=").append(this.getMetaConstraints().size());
        sb.append(", cascadedMemberCount=").append(this.cascadedMembers.size());
        sb.append(", defaultGroupSequence=").append(this.getDefaultGroupSequence(null));
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuilderDelegate {
        private final ConstraintHelper constraintHelper;
        private MetaDataBuilder propertyBuilder;
        private MethodMetaData.Builder methodBuilder;

        public BuilderDelegate(ConstrainedElement constrainedElement, ConstraintHelper constraintHelper) {
            this.constraintHelper = constraintHelper;
            switch (constrainedElement.getKind()) {
                case FIELD: {
                    ConstrainedField constrainedField = (ConstrainedField)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(constrainedField, constraintHelper);
                    break;
                }
                case METHOD: {
                    ConstrainedMethod constrainedMethod = (ConstrainedMethod)constrainedElement;
                    this.methodBuilder = new MethodMetaData.Builder(constrainedMethod, constraintHelper);
                    if (!constrainedMethod.isGetterMethod()) break;
                    this.propertyBuilder = new PropertyMetaData.Builder(constrainedMethod, constraintHelper);
                    break;
                }
                case TYPE: {
                    ConstrainedType constrainedType = (ConstrainedType)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(constrainedType, constraintHelper);
                }
            }
        }

        public boolean add(ConstrainedElement constrainedElement) {
            boolean added = false;
            if (this.methodBuilder != null && this.methodBuilder.accepts(constrainedElement)) {
                this.methodBuilder.add(constrainedElement);
                added = true;
            }
            if (this.propertyBuilder != null && this.propertyBuilder.accepts(constrainedElement)) {
                this.propertyBuilder.add(constrainedElement);
                if (!added && constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && this.methodBuilder == null) {
                    ConstrainedMethod constrainedMethod = (ConstrainedMethod)constrainedElement;
                    this.methodBuilder = new MethodMetaData.Builder(constrainedMethod, this.constraintHelper);
                }
                added = true;
            }
            return added;
        }

        public Set<ConstraintMetaData> build(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
            HashSet<ConstraintMetaData> theValue = CollectionHelper.newHashSet();
            if (this.propertyBuilder != null) {
                theValue.add(this.propertyBuilder.build());
            }
            if (this.methodBuilder != null) {
                theValue.add(this.methodBuilder.build());
            }
            return theValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanMetaDataBuilder<T> {
        private final ConstraintHelper constraintHelper;
        private final Class<T> beanClass;
        private final Set<BuilderDelegate> builders = CollectionHelper.newHashSet();
        private ConfigurationSource sequenceSource;
        private ConfigurationSource providerSource;
        private List<Class<?>> defaultGroupSequence;
        private Class<? extends DefaultGroupSequenceProvider<?>> defaultGroupSequenceProvider;

        public BeanMetaDataBuilder(ConstraintHelper constraintHelper, Class<T> beanClass) {
            this.beanClass = beanClass;
            this.constraintHelper = constraintHelper;
        }

        public static <T> BeanMetaDataBuilder<T> getInstance(ConstraintHelper constraintHelper, Class<T> beanClass) {
            return new BeanMetaDataBuilder<T>(constraintHelper, beanClass);
        }

        public void add(BeanConfiguration<?> configuration) {
            if (configuration.getBeanClass().equals(this.beanClass)) {
                if (configuration.getDefaultGroupSequence() != null && (this.sequenceSource == null || configuration.getSource().getPriority() >= this.sequenceSource.getPriority())) {
                    this.sequenceSource = configuration.getSource();
                    this.defaultGroupSequence = configuration.getDefaultGroupSequence();
                }
                if (configuration.getDefaultGroupSequenceProvider() != null && (this.providerSource == null || configuration.getSource().getPriority() >= this.providerSource.getPriority())) {
                    this.providerSource = configuration.getSource();
                    this.defaultGroupSequenceProvider = configuration.getDefaultGroupSequenceProvider();
                }
            }
            for (ConstrainedElement oneConstrainedElement : configuration.getConstrainedElements()) {
                this.addMetaDataToBuilder(oneConstrainedElement, this.builders);
            }
        }

        private void addMetaDataToBuilder(ConstrainedElement constrainableElement, Set<BuilderDelegate> builders) {
            for (BuilderDelegate oneBuilder : builders) {
                boolean foundBuilder = oneBuilder.add(constrainableElement);
                if (!foundBuilder) continue;
                return;
            }
            builders.add(new BuilderDelegate(constrainableElement, this.constraintHelper));
        }

        public BeanMetaDataImpl<T> build() {
            HashSet<ConstraintMetaData> aggregatedElements = CollectionHelper.newHashSet();
            for (BuilderDelegate oneBuilder : this.builders) {
                aggregatedElements.addAll(oneBuilder.build(this.defaultGroupSequence != null && this.defaultGroupSequence.size() > 1 || this.defaultGroupSequenceProvider != null, this.defaultGroupSequence));
            }
            return new BeanMetaDataImpl<T>(this.beanClass, this.defaultGroupSequence, this.defaultGroupSequenceProvider, aggregatedElements);
        }
    }
}

