/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyValidatorFactory
implements ValidatorFactory {
    private static final Log log = LoggerFactory.make();
    private final Configuration<?> configuration;
    private volatile ValidatorFactory delegate;

    public LazyValidatorFactory() {
        this(null);
    }

    public LazyValidatorFactory(Configuration<?> configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            LazyValidatorFactory lazyValidatorFactory = this;
            synchronized (lazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    private ValidatorFactory initFactory() {
        if (this.configuration == null) {
            return Validation.byDefaultProvider().providerResolver((ValidationProviderResolver)new HibernateProviderResolver()).configure().buildValidatorFactory();
        }
        return this.configuration.buildValidatorFactory();
    }

    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HibernateProviderResolver
    implements ValidationProviderResolver {
        private static final Map<ClassLoader, List<ValidationProvider<?>>> providersPerClassloader = new WeakHashMap();
        private static final String SERVICES_FILE = "META-INF/services/" + ValidationProvider.class.getName();
        private static final String HIBERNATE_VALIDATOR_PROVIDER_NAME = HibernateValidator.class.getName();

        private HibernateProviderResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ValidationProvider<?>> getValidationProviders() {
            List<ValidationProvider<?>> providers;
            ClassLoader classloader = GetClassLoader.fromContext().run();
            if (classloader == null) {
                classloader = GetClassLoader.fromClass(HibernateProviderResolver.class).run();
            }
            Map<ClassLoader, List<ValidationProvider<?>>> map = providersPerClassloader;
            synchronized (map) {
                providers = providersPerClassloader.get(classloader);
            }
            if (providers == null) {
                List<String> providerNames = this.loadProviderNamesFromServiceFile(classloader);
                providers = this.instantiateProviders(providerNames);
            }
            map = providersPerClassloader;
            synchronized (map) {
                providersPerClassloader.put(classloader, Collections.unmodifiableList(providers));
            }
            return providers;
        }

        private List<ValidationProvider<?>> instantiateProviders(List<String> providerNames) {
            ArrayList providers = new ArrayList();
            for (String providerName : providerNames) {
                Object providerClass;
                try {
                    providerClass = LoadClass.action(providerName, HibernateProviderResolver.class).run();
                }
                catch (ValidationException e) {
                    log.unableToLoadProviderClass(providerName);
                    continue;
                }
                try {
                    providers.add((ValidationProvider)((Class)providerClass).newInstance());
                }
                catch (IllegalAccessException e) {
                    throw log.getUnableToInstantiateBeanValidationProviderException(providerNames, e);
                }
                catch (InstantiationException e) {
                    throw log.getUnableToInstantiateBeanValidationProviderException(providerNames, e);
                }
            }
            return providers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> loadProviderNamesFromServiceFile(ClassLoader classloader) {
            ArrayList<String> providerNames = new ArrayList<String>();
            try {
                Enumeration<URL> providerDefinitions = classloader.getResources(SERVICES_FILE);
                while (providerDefinitions.hasMoreElements()) {
                    URL url = providerDefinitions.nextElement();
                    InputStream stream = url.openStream();
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
                        String name = reader.readLine();
                        while (name != null) {
                            if (!(name = name.trim()).startsWith("#")) {
                                providerNames.add(name);
                            }
                            name = reader.readLine();
                        }
                    }
                    finally {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw log.getUnableToReadServicesFileException(SERVICES_FILE, e);
            }
            int index = providerNames.indexOf(HIBERNATE_VALIDATOR_PROVIDER_NAME);
            if (index < 0) {
                providerNames.add(0, HIBERNATE_VALIDATOR_PROVIDER_NAME);
            } else if (index > 0) {
                providerNames.remove(HIBERNATE_VALIDATOR_PROVIDER_NAME);
                providerNames.add(0, HIBERNATE_VALIDATOR_PROVIDER_NAME);
            }
            return providerNames;
        }
    }
}

