/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.MethodConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.PropertyConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstraintMappingContextImplBase {
    private static final Log log = LoggerFactory.make();
    protected final Class<?> beanClass;
    protected final ConstraintMappingContext mapping;

    public ConstraintMappingContextImplBase(Class<?> beanClass, ConstraintMappingContext mapping) {
        this.beanClass = beanClass;
        this.mapping = mapping;
    }

    public <C> TypeConstraintMappingContext<C> type(Class<C> type) {
        Contracts.assertNotNull(this.beanClass, Messages.MESSAGES.beanTypeMustNotBeNull());
        return new TypeConstraintMappingContextImpl(type, this.mapping);
    }

    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        Contracts.assertNotNull(property, "The property name must not be null.");
        Contracts.assertNotNull((Object)elementType, "The element type must not be null.");
        Contracts.assertNotEmpty(property, Messages.MESSAGES.propertyNameMustNotBeEmpty());
        Member member = ReflectionHelper.getMember(this.beanClass, property, elementType);
        if (member == null) {
            throw log.getUnableToFindPropertyWithAccessException(this.beanClass, property, elementType);
        }
        return new PropertyConstraintMappingContextImpl(this.beanClass, member, this.mapping);
    }

    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(name, Messages.MESSAGES.methodNameMustNotBeNull());
        Method method = ReflectionHelper.getDeclaredMethod(this.beanClass, name, parameterTypes);
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> oneParameterType : parameterTypes) {
                sb.append(oneParameterType.getName()).append(", ");
            }
            String parameterTypesAsString = sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
            throw log.getUnableToFindMethodException(this.beanClass, name, parameterTypesAsString);
        }
        return new MethodConstraintMappingContextImpl(this.beanClass, method, this.mapping);
    }
}

