/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.groups;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.GroupDefinitionException;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultValidationOrder
implements ValidationOrder {
    private static final Log log = LoggerFactory.make();
    private List<Group> groupList = CollectionHelper.newArrayList();
    private Map<Class<?>, Sequence> sequenceMap = CollectionHelper.newHashMap();

    @Override
    public Iterator<Group> getGroupIterator() {
        return this.groupList.iterator();
    }

    @Override
    public Iterator<Sequence> getSequenceIterator() {
        return this.sequenceMap.values().iterator();
    }

    public void insertGroup(Group group) {
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
    }

    public void insertSequence(Sequence sequence) {
        if (sequence == null) {
            return;
        }
        if (!this.sequenceMap.containsKey(sequence.getDefiningClass())) {
            this.sequenceMap.put(sequence.getDefiningClass(), sequence);
        }
    }

    public String toString() {
        return "ValidationOrder{groupList=" + this.groupList + ", sequenceMap=" + this.sequenceMap + '}';
    }

    @Override
    public void assertDefaultGroupSequenceIsExpandable(List<Class<?>> defaultGroupSequence) throws GroupDefinitionException {
        for (Map.Entry<Class<?>, Sequence> entry : this.sequenceMap.entrySet()) {
            List<Group> sequenceGroups = entry.getValue().getComposingGroups();
            int defaultGroupIndex = sequenceGroups.indexOf(Group.DEFAULT_GROUP);
            if (defaultGroupIndex == -1) continue;
            List<Group> defaultGroupList = this.buildTempGroupList(defaultGroupSequence);
            this.ensureDefaultGroupSequenceIsExpandable(sequenceGroups, defaultGroupList, defaultGroupIndex);
        }
    }

    private void ensureDefaultGroupSequenceIsExpandable(List<Group> groupList, List<Group> defaultGroupList, int defaultGroupIndex) {
        for (int i = 0; i < defaultGroupList.size(); ++i) {
            int index;
            Group group = defaultGroupList.get(i);
            if (Group.DEFAULT_GROUP.equals(group) || (index = groupList.indexOf(group)) == -1 || i == 0 && index == defaultGroupIndex - 1 || i == defaultGroupList.size() - 1 && index == defaultGroupIndex + 1) continue;
            throw log.getUnableToExpandDefaultGroupListException(defaultGroupList, groupList);
        }
    }

    private List<Group> buildTempGroupList(List<Class<?>> defaultGroupSequence) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Class<?> clazz : defaultGroupSequence) {
            Group g = new Group(clazz);
            groups.add(g);
        }
        return groups;
    }
}

